/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.processingstep;

import com.google.common.collect.ImmutableSet;
import com.squareup.javapoet.ClassName;
import dagger.internal.codegen.javapoet.TypeNames;
import dagger.internal.codegen.processingstep.TypeCheckingProcessingStep;
import dagger.internal.codegen.validation.BindsInstanceMethodValidator;
import dagger.internal.codegen.validation.BindsInstanceParameterValidator;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XElementKt;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XExecutableParameterElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XMessager;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XMethodElement;
import javax.inject.Inject;

final class BindsInstanceProcessingStep
extends TypeCheckingProcessingStep<XElement> {
    private final BindsInstanceMethodValidator methodValidator;
    private final BindsInstanceParameterValidator parameterValidator;
    private final XMessager messager;

    @Inject
    BindsInstanceProcessingStep(BindsInstanceMethodValidator methodValidator, BindsInstanceParameterValidator parameterValidator, XMessager messager) {
        this.methodValidator = methodValidator;
        this.parameterValidator = parameterValidator;
        this.messager = messager;
    }

    public ImmutableSet<ClassName> annotationClassNames() {
        return ImmutableSet.of((Object)TypeNames.BINDS_INSTANCE);
    }

    @Override
    protected void process(XElement element, ImmutableSet<ClassName> annotations) {
        if (XElementKt.isMethod((XElement)element)) {
            this.methodValidator.validate((XMethodElement)element).printMessagesTo(this.messager);
        } else if (XElementKt.isMethodParameter((XElement)element)) {
            this.parameterValidator.validate((XExecutableParameterElement)element).printMessagesTo(this.messager);
        } else {
            throw new AssertionError(element);
        }
    }
}

