/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.base;

import com.google.common.base.Ascii;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.squareup.javapoet.ClassName;
import dagger.Reusable;
import dagger.internal.codegen.compileroption.CompilerOptions;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.javapoet.TypeNames;
import dagger.internal.codegen.xprocessing.XAnnotationValues;
import dagger.internal.codegen.xprocessing.XAnnotations;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.internal.codegen.xprocessing.XExecutableTypes;
import dagger.internal.codegen.xprocessing.XTypes;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XAnnotation;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XAnnotationValue;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XElementKt;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XExecutableElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XExecutableType;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XProcessingEnv;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XType;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XTypeElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XTypeKt;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.compat.XConverters;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.TypeMirror;

@Reusable
public final class DaggerSuperficialValidation {
    private final boolean isStrictValidationEnabled;
    private final XProcessingEnv processingEnv;

    public static XTypeElement requireTypeElement(XProcessingEnv processingEnv, ClassName className) {
        return DaggerSuperficialValidation.requireTypeElement(processingEnv, className.canonicalName());
    }

    public static XTypeElement requireTypeElement(XProcessingEnv processingEnv, String className) {
        XTypeElement type = processingEnv.findTypeElement(className);
        if (type == null) {
            throw new ValidationException.KnownErrorType(className);
        }
        return type;
    }

    @Inject
    DaggerSuperficialValidation(XProcessingEnv processingEnv, CompilerOptions compilerOptions) {
        this.processingEnv = processingEnv;
        this.isStrictValidationEnabled = compilerOptions.strictSuperficialValidation();
    }

    public void validateTypeOf(XElement element) {
        try {
            if (XElementKt.isTypeElement((XElement)element)) {
                this.validateType(Ascii.toLowerCase((String)XElements.getKindName(element)), XElements.asTypeElement(element).getType());
            } else if (XElementKt.isVariableElement((XElement)element)) {
                this.validateType(Ascii.toLowerCase((String)XElements.getKindName(element)) + " type", XElements.asVariable(element).getType());
            } else if (XElements.isExecutable(element)) {
                this.validateExecutableType(XElements.asExecutable(element).getExecutableType());
            } else if (XElements.isEnumEntry(element)) {
                this.validateType(Ascii.toLowerCase((String)XElements.getKindName(element)), XElements.asEnumEntry(element).getEnumTypeElement().getType());
            }
        }
        catch (RuntimeException exception) {
            throw ValidationException.from(exception).append(element);
        }
    }

    public void validateSuperTypeOf(XTypeElement element) {
        try {
            this.validateType("superclass", element.getSuperType());
        }
        catch (RuntimeException exception) {
            throw ValidationException.from(exception).append((XElement)element);
        }
    }

    public void validateThrownTypesOf(XExecutableElement element) {
        try {
            this.validateTypes("thrown type", element.getThrownTypes());
        }
        catch (RuntimeException exception) {
            throw ValidationException.from(exception).append((XElement)element);
        }
    }

    public void validateAnnotationTypesOf(XElement element) {
        element.getAllAnnotations().forEach(annotation -> this.validateAnnotationTypeOf(element, (XAnnotation)annotation));
    }

    public void validateAnnotationTypeOf(XElement element, XAnnotation annotation) {
        try {
            this.validateType("annotation type", annotation.getType());
        }
        catch (RuntimeException exception) {
            throw ValidationException.from(exception).append(annotation).append(element);
        }
    }

    public void validateAnnotationsOf(XElement element) {
        try {
            this.validateAnnotations(element.getAllAnnotations());
        }
        catch (RuntimeException exception) {
            throw ValidationException.from(exception).append(element);
        }
    }

    public void validateAnnotationOf(XElement element, XAnnotation annotation) {
        try {
            this.validateAnnotation(annotation);
        }
        catch (RuntimeException exception) {
            throw ValidationException.from(exception).append(element);
        }
    }

    public void validateTypeHierarchyOf(String typeDescription, XElement element, XType type) {
        try {
            this.validateTypeHierarchy(typeDescription, type);
        }
        catch (RuntimeException exception) {
            throw ValidationException.from(exception).append(element);
        }
    }

    private void validateTypeHierarchy(String desc, XType type) {
        this.validateType(desc, type);
        try {
            type.getSuperTypes().forEach(supertype -> this.validateTypeHierarchy("supertype", (XType)supertype));
        }
        catch (RuntimeException exception) {
            throw ValidationException.from(exception).append(desc, type);
        }
    }

    private void validateElements(Collection<? extends XElement> elements) {
        elements.forEach(this::validateElement);
    }

    public void validateElement(XElement element) {
        Preconditions.checkNotNull((Object)element);
        this.validateAnnotationsOf(element);
        try {
            if (XElementKt.isTypeElement((XElement)element)) {
                XTypeElement typeElement = XElements.asTypeElement(element);
                this.validateElements(typeElement.getTypeParameters());
                this.validateTypes("interface", typeElement.getSuperInterfaces());
                if (typeElement.getSuperType() != null) {
                    this.validateType("superclass", typeElement.getSuperType());
                }
                if (typeElement.hasAnnotation(TypeNames.COMPONENT)) {
                    this.validateElements((Collection)typeElement.getEnclosedElements().stream().filter(member -> !XElements.isStatic(member)).collect(DaggerStreams.toImmutableList()));
                } else {
                    this.validateElements(typeElement.getEnclosedElements());
                }
            } else if (XElements.isExecutable(element)) {
                if (XElementKt.isMethod((XElement)element)) {
                    this.validateType("return type", XElements.asMethod(element).getReturnType());
                }
                XExecutableElement executableElement = XElements.asExecutable(element);
                this.validateTypes("thrown type", executableElement.getThrownTypes());
                this.validateElements(executableElement.getTypeParameters());
                this.validateElements(executableElement.getParameters());
            } else if (XElements.isTypeParameter(element)) {
                this.validateTypes("bound type", XElements.asTypeParameter(element).getBounds());
            }
        }
        catch (RuntimeException exception) {
            throw ValidationException.from(exception).append(element);
        }
        this.validateTypeOf(element);
    }

    private void validateTypes(String desc, Collection<? extends XType> types) {
        types.forEach(type -> this.validateType(desc, (XType)type));
    }

    private void validateType(String desc, XType type) {
        Preconditions.checkNotNull((Object)type);
        XTypes.resolveIfNeeded(type);
        try {
            if (XTypeKt.isArray((XType)type)) {
                this.validateType("array component type", XTypes.asArray(type).getComponentType());
            } else if (XTypes.isDeclared(type)) {
                if (this.isStrictValidationEnabled && this.isErrorKind(type)) {
                    throw new ValidationException.KnownErrorType(type);
                }
                type.getTypeArguments().forEach(typeArg -> this.validateType("type argument", (XType)typeArg));
            } else if (XTypes.isWildcard(type)) {
                if (type.extendsBound() != null) {
                    this.validateType("extends bound type", type.extendsBound());
                }
            } else if (this.isErrorKind(type)) {
                throw new ValidationException.KnownErrorType(type);
            }
        }
        catch (RuntimeException e) {
            throw ValidationException.from(e).append(desc, type);
        }
    }

    private boolean isErrorKind(XType type) {
        return type.isError() && (this.processingEnv.getBackend() != XProcessingEnv.Backend.JAVAC || !type.getTypeName().toString().contentEquals("error.NonExistentClass"));
    }

    private void validateExecutableType(XExecutableType type) {
        try {
            this.validateTypes("parameter type", type.getParameterTypes());
            this.validateTypes("thrown type", type.getThrownTypes());
            this.validateTypes("type variable", (Collection<? extends XType>)this.getTypeVariables(type));
            if (XExecutableTypes.isMethodType(type)) {
                this.validateType("return type", XExecutableTypes.asMethodType(type).getReturnType());
            }
        }
        catch (RuntimeException e) {
            throw ValidationException.from(e).append(type);
        }
    }

    private ImmutableList<XType> getTypeVariables(XExecutableType executableType) {
        switch (this.processingEnv.getBackend()) {
            case JAVAC: {
                return (ImmutableList)XConverters.toJavac((XExecutableType)executableType).getTypeVariables().stream().map(typeVariable -> XConverters.toXProcessing((TypeMirror)typeVariable, (XProcessingEnv)this.processingEnv)).collect(DaggerStreams.toImmutableList());
            }
            case KSP: {
                return ImmutableList.of();
            }
        }
        throw new AssertionError((Object)("Unexpected backend: " + this.processingEnv.getBackend()));
    }

    private void validateAnnotations(Collection<XAnnotation> annotations) {
        annotations.forEach(this::validateAnnotation);
    }

    private void validateAnnotation(XAnnotation annotation) {
        try {
            this.validateType("annotation type", annotation.getType());
            try {
                this.validateAnnotationValues((Collection<XAnnotationValue>)this.getDefaultValues(annotation));
                this.validateAnnotationValues(annotation.getAnnotationValues());
            }
            catch (RuntimeException exception) {
                throw ValidationException.from(exception).append(annotation);
            }
        }
        catch (RuntimeException exception) {
            throw ValidationException.from(exception).append("annotation type: " + (annotation.getType().isError() ? annotation.getName() : annotation.getClassName().canonicalName()));
        }
    }

    private ImmutableList<XAnnotationValue> getDefaultValues(XAnnotation annotation) {
        switch (this.processingEnv.getBackend()) {
            case JAVAC: {
                return (ImmutableList)annotation.getTypeElement().getDeclaredMethods().stream().map(XConverters::toJavac).filter(method -> method.getDefaultValue() != null).map(method -> XConverters.toXProcessing((AnnotationValue)method.getDefaultValue(), (ExecutableElement)method, (XProcessingEnv)this.processingEnv)).collect(DaggerStreams.toImmutableList());
            }
            case KSP: {
                return ImmutableList.of();
            }
        }
        throw new AssertionError((Object)("Unexpected backend: " + this.processingEnv.getBackend()));
    }

    private void validateAnnotationValues(Collection<XAnnotationValue> values) {
        values.forEach(this::validateAnnotationValue);
    }

    private void validateAnnotationValue(XAnnotationValue value) {
        try {
            XType expectedType = value.getValueType();
            if (this.processingEnv.getBackend() == XProcessingEnv.Backend.KSP && value.getValue() == null) {
                throw new ValidationException.KnownErrorType("<error>");
            }
            if (value.hasListValue()) {
                this.validateAnnotationValues(value.asAnnotationValueList());
            } else if (value.hasAnnotationValue()) {
                this.validateIsEquivalentType(value.asAnnotation().getType(), expectedType);
                this.validateAnnotation(value.asAnnotation());
            } else if (value.hasEnumValue()) {
                this.validateIsEquivalentType(value.asEnum().getEnumTypeElement().getType(), expectedType);
                this.validateElement((XElement)value.asEnum());
            } else if (value.hasTypeValue()) {
                this.validateType("annotation value type", value.asType());
            } else {
                this.validateIsTypeOf(expectedType, ClassName.get(value.getValue().getClass()));
            }
        }
        catch (RuntimeException e) {
            throw ValidationException.from(e).append(value);
        }
    }

    private void validateIsTypeOf(XType expectedType, ClassName className) {
        if (!XTypes.isTypeOf(expectedType.boxed(), className)) {
            throw new ValidationException.UnknownErrorType();
        }
    }

    private void validateIsEquivalentType(XType type, XType expectedType) {
        if (!XTypes.equivalence().equivalent((Object)type, (Object)expectedType)) {
            throw new ValidationException.KnownErrorType(type);
        }
    }

    public static abstract class ValidationException
    extends RuntimeException {
        private Optional<XElement> lastReportedElement = Optional.empty();
        private final List<String> messages = new ArrayList<String>();

        private static ValidationException from(Throwable throwable) {
            if (throwable instanceof ValidationException) {
                return (ValidationException)throwable;
            }
            if (throwable instanceof TypeNotPresentException) {
                return new KnownErrorType(((TypeNotPresentException)throwable).typeName());
            }
            return new UnexpectedException(throwable);
        }

        private ValidationException() {
            super("");
        }

        private ValidationException(Throwable throwable) {
            super("", throwable);
        }

        private ValidationException append(XElement element) {
            this.lastReportedElement = Optional.of(element);
            return this.append(this.getMessageForElement(element));
        }

        private ValidationException append(String desc, XType type) {
            return this.append(String.format("type (%s %s): %s", XTypes.getKindName(type), desc, XTypes.toStableString(type)));
        }

        private ValidationException append(XExecutableType type) {
            return this.append(String.format("type (EXECUTABLE %s): %s", Ascii.toLowerCase((String)XExecutableTypes.getKindName(type)), XExecutableTypes.toStableString(type)));
        }

        private ValidationException append(XAnnotation annotation) {
            return this.append(String.format("annotation: %s", XAnnotations.toStableString(annotation)));
        }

        private ValidationException append(String message) {
            this.messages.add(message);
            return this;
        }

        private ValidationException append(XAnnotationValue value) {
            return this.append(String.format("annotation value (%s): %s=%s", XAnnotationValues.getKindName(value), value.getName(), XAnnotationValues.toStableString(value)));
        }

        @Override
        public String getMessage() {
            return String.format("\n  Validation trace:\n    => %s", this.getTrace());
        }

        public String getTrace() {
            return String.join((CharSequence)"\n    => ", (Iterable<? extends CharSequence>)this.getMessageInternal().reverse());
        }

        private ImmutableList<String> getMessageInternal() {
            if (!this.lastReportedElement.isPresent()) {
                return ImmutableList.copyOf(this.messages);
            }
            ArrayList<String> newMessages = new ArrayList<String>(this.messages);
            XElement element = this.lastReportedElement.get();
            while (ValidationException.shouldAppendEnclosingElement(element)) {
                element = element.getEnclosingElement();
                newMessages.add(this.getMessageForElement(element));
            }
            return ImmutableList.copyOf(newMessages);
        }

        private static boolean shouldAppendEnclosingElement(XElement element) {
            return element.getEnclosingElement() != null && !XElementKt.isTypeElement((XElement)element) && (XElements.isExecutable(element.getEnclosingElement()) || XElementKt.isTypeElement((XElement)element.getEnclosingElement()));
        }

        private String getMessageForElement(XElement element) {
            return String.format("element (%s): %s", Ascii.toUpperCase((String)XElements.getKindName(element)), XElements.toStableString(element));
        }

        public static final class KnownErrorType
        extends ValidationException {
            private final String errorTypeName;

            private KnownErrorType(XType errorType) {
                this.errorTypeName = XTypes.toStableString(errorType);
            }

            private KnownErrorType(String errorTypeName) {
                this.errorTypeName = errorTypeName;
            }

            public String getErrorTypeName() {
                return this.errorTypeName;
            }
        }

        public static final class UnexpectedException
        extends ValidationException {
            private UnexpectedException(Throwable throwable) {
                super(throwable);
            }
        }

        public static final class UnknownErrorType
        extends ValidationException {
        }
    }
}

