/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.binding;

import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.CheckReturnValue;
import dagger.internal.codegen.base.ContributionType;
import dagger.internal.codegen.base.MapType;
import dagger.internal.codegen.base.SetType;
import dagger.internal.codegen.binding.Binding;
import dagger.internal.codegen.binding.MapKeys;
import dagger.internal.codegen.binding.Nullability;
import dagger.internal.codegen.compileroption.CompilerOptions;
import dagger.internal.codegen.model.BindingKind;
import dagger.internal.codegen.model.Key;
import dagger.internal.codegen.model.Scope;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.internal.codegen.xprocessing.XTypes;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XAnnotation;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XElementKt;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XType;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XTypeElement;
import java.util.Optional;

@CheckReturnValue
public abstract class ContributionBinding
extends Binding
implements ContributionType.HasContributionType {
    private static final ImmutableSet<BindingKind> KINDS_TO_CHECK_FOR_NULL = ImmutableSet.of((Object)((Object)BindingKind.PROVISION), (Object)((Object)BindingKind.COMPONENT_PROVISION));

    public abstract Nullability nullability();

    public boolean shouldCheckForNull(CompilerOptions compilerOptions) {
        return KINDS_TO_CHECK_FOR_NULL.contains((Object)this.kind()) && this.contributedPrimitiveType().isEmpty() && !this.isNullable() && compilerOptions.doCheckForNulls();
    }

    public Optional<XAnnotation> mapKey() {
        return this.bindingElement().flatMap(MapKeys::getMapKey);
    }

    public final Optional<XType> contributedPrimitiveType() {
        return this.bindingElement().filter(XElementKt::isMethod).map(bindingElement -> XElements.asMethod(bindingElement).getReturnType()).filter(XTypes::isPrimitive);
    }

    @Override
    public boolean requiresModuleInstance() {
        return this.contributingModule().isPresent() && this.bindingElement().isPresent() && !XElements.isAbstract(this.bindingElement().get()) && !XElements.isStatic(this.bindingElement().get()) && !this.isContributingModuleKotlinObject();
    }

    @Override
    public final boolean isNullable() {
        return this.nullability().isNullable();
    }

    private boolean isContributingModuleKotlinObject() {
        return this.contributingModule().isPresent() && (this.contributingModule().get().isKotlinObject() || this.contributingModule().get().isCompanionObject());
    }

    public final XType contributedType() {
        switch (this.contributionType()) {
            case MAP: {
                return MapType.from(this.key()).unwrappedFrameworkValueType();
            }
            case SET: {
                return SetType.from(this.key()).elementType();
            }
            case SET_VALUES: 
            case UNIQUE: {
                return this.key().type().xprocessing();
            }
        }
        throw new AssertionError();
    }

    public abstract Builder<?, ?> toBuilder();

    static abstract class Builder<C extends ContributionBinding, B extends Builder<C, B>> {
        Builder() {
        }

        @CanIgnoreReturnValue
        abstract B unresolved(Optional<? extends Binding> var1);

        @CanIgnoreReturnValue
        abstract B bindingElement(XElement var1);

        @CanIgnoreReturnValue
        abstract B bindingElement(Optional<XElement> var1);

        @CanIgnoreReturnValue
        final B clearBindingElement() {
            return this.bindingElement(Optional.empty());
        }

        @CanIgnoreReturnValue
        abstract B contributingModule(XTypeElement var1);

        @CanIgnoreReturnValue
        abstract B key(Key var1);

        @CanIgnoreReturnValue
        abstract B scope(Optional<Scope> var1);

        abstract C build();
    }
}

