/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.validation;

import com.google.common.collect.ImmutableSet;
import com.squareup.javapoet.ClassName;
import dagger.internal.codegen.base.ContributionType;
import dagger.internal.codegen.base.DaggerSuperficialValidation;
import dagger.internal.codegen.base.SetType;
import dagger.internal.codegen.binding.BindsTypeChecker;
import dagger.internal.codegen.binding.InjectionAnnotations;
import dagger.internal.codegen.javapoet.TypeNames;
import dagger.internal.codegen.validation.BindingElementValidator;
import dagger.internal.codegen.validation.BindingMethodValidator;
import dagger.internal.codegen.validation.DependencyRequestValidator;
import dagger.internal.codegen.xprocessing.XTypes;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XMethodElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XProcessingEnv;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XType;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XVariableElement;
import javax.inject.Inject;

final class BindsMethodValidator
extends BindingMethodValidator {
    private final BindsTypeChecker bindsTypeChecker;
    private final DaggerSuperficialValidation superficialValidation;

    @Inject
    BindsMethodValidator(BindsTypeChecker bindsTypeChecker, DaggerSuperficialValidation superficialValidation, XProcessingEnv processingEnv, DependencyRequestValidator dependencyRequestValidator, InjectionAnnotations injectionAnnotations) {
        super(TypeNames.BINDS, (Iterable<ClassName>)ImmutableSet.of((Object)TypeNames.MODULE, (Object)TypeNames.PRODUCER_MODULE), BindingMethodValidator.Abstractness.MUST_BE_ABSTRACT, BindingMethodValidator.ExceptionSuperclass.NO_EXCEPTIONS, BindingElementValidator.AllowsMultibindings.ALLOWS_MULTIBINDINGS, BindingElementValidator.AllowsScoping.ALLOWS_SCOPING, processingEnv, dependencyRequestValidator, injectionAnnotations);
        this.bindsTypeChecker = bindsTypeChecker;
        this.superficialValidation = superficialValidation;
    }

    @Override
    protected BindingElementValidator.ElementValidator elementValidator(XMethodElement method) {
        return new Validator(method);
    }

    private class Validator
    extends BindingMethodValidator.MethodValidator {
        private final XMethodElement method;

        Validator(XMethodElement method) {
            super(method);
            this.method = method;
        }

        @Override
        protected void checkParameters() {
            if (this.method.getParameters().size() != 1) {
                this.report.addError(BindsMethodValidator.this.bindingMethods("must have exactly one parameter, whose type is assignable to the return type", new Object[0]));
            } else {
                super.checkParameters();
            }
        }

        @Override
        protected void checkParameter(XVariableElement parameter) {
            super.checkParameter(parameter);
            XType returnType = this.boxIfNecessary(this.method.getReturnType());
            XType parameterType = parameter.getType();
            ContributionType contributionType = ContributionType.fromBindingElement((XElement)this.method);
            if (contributionType.equals((Object)ContributionType.SET_VALUES) && !SetType.isSet(returnType)) {
                this.report.addError("@Binds @ElementsIntoSet methods must return a Set and take a Set parameter");
            }
            if (!BindsMethodValidator.this.bindsTypeChecker.isAssignable(parameterType, returnType, contributionType)) {
                BindsMethodValidator.this.superficialValidation.validateTypeHierarchyOf("return type", (XElement)this.method, returnType);
                BindsMethodValidator.this.superficialValidation.validateTypeHierarchyOf("parameter", (XElement)parameter, parameterType);
                this.report.addError("@Binds methods' parameter type must be assignable to the return type");
            }
        }

        private XType boxIfNecessary(XType maybePrimitive) {
            return XTypes.isPrimitive(maybePrimitive) ? maybePrimitive.boxed() : maybePrimitive;
        }
    }
}

