/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.validation;

import com.google.common.collect.ImmutableSet;
import com.squareup.javapoet.ClassName;
import dagger.internal.codegen.base.FrameworkTypes;
import dagger.internal.codegen.base.MapType;
import dagger.internal.codegen.base.SetType;
import dagger.internal.codegen.binding.InjectionAnnotations;
import dagger.internal.codegen.javapoet.TypeNames;
import dagger.internal.codegen.validation.BindingElementValidator;
import dagger.internal.codegen.validation.BindingMethodValidator;
import dagger.internal.codegen.validation.DependencyRequestValidator;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.internal.codegen.xprocessing.XTypes;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XMemberContainer;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XMethodElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XProcessingEnv;
import javax.inject.Inject;

class MultibindsMethodValidator
extends BindingMethodValidator {
    @Inject
    MultibindsMethodValidator(XProcessingEnv processingEnv, DependencyRequestValidator dependencyRequestValidator, InjectionAnnotations injectionAnnotations) {
        super(TypeNames.MULTIBINDS, (Iterable<ClassName>)ImmutableSet.of((Object)TypeNames.MODULE, (Object)TypeNames.PRODUCER_MODULE), BindingMethodValidator.Abstractness.MUST_BE_ABSTRACT, BindingMethodValidator.ExceptionSuperclass.NO_EXCEPTIONS, BindingElementValidator.AllowsMultibindings.NO_MULTIBINDINGS, BindingElementValidator.AllowsScoping.NO_SCOPING, processingEnv, dependencyRequestValidator, injectionAnnotations);
    }

    @Override
    protected BindingElementValidator.ElementValidator elementValidator(XMethodElement method) {
        return new Validator(method);
    }

    private class Validator
    extends BindingMethodValidator.MethodValidator {
        private final XMethodElement method;

        Validator(XMethodElement method) {
            super(method);
            this.method = method;
        }

        @Override
        protected void checkParameters() {
            if (!this.method.getParameters().isEmpty()) {
                this.report.addError(MultibindsMethodValidator.this.bindingMethods("cannot have parameters", new Object[0]));
            }
        }

        @Override
        protected void checkType() {
            if (MapType.isMap(this.method.getReturnType())) {
                this.checkMapType(MapType.from(this.method.getReturnType()));
            } else if (SetType.isSet(this.method.getReturnType())) {
                this.checkSetType(SetType.from(this.method.getReturnType()));
            } else {
                this.report.addError(MultibindsMethodValidator.this.bindingMethods("return type must be either a Set or Map type.", new Object[0]));
            }
        }

        private void checkMapType(MapType mapType) {
            if (mapType.isRawType()) {
                this.report.addError(MultibindsMethodValidator.this.bindingMethods("return type cannot be a raw Map type", new Object[0]));
            } else if (XTypes.isWildcard(mapType.keyType())) {
                this.report.addError(MultibindsMethodValidator.this.bindingMethods("return type cannot use a wildcard as the Map key type.", new Object[0]));
            } else if (XTypes.isWildcard(mapType.valueType())) {
                this.report.addError(MultibindsMethodValidator.this.bindingMethods("return type cannot use a wildcard as the Map value type.", new Object[0]));
            } else if (FrameworkTypes.isFrameworkType(mapType.valueType())) {
                String frameworkTypeName = XElements.getSimpleName((XMemberContainer)mapType.valueType().getTypeElement());
                this.report.addError(MultibindsMethodValidator.this.bindingMethods("return type cannot use '%s' in the Map value type.", frameworkTypeName));
            }
        }

        private void checkSetType(SetType setType) {
            if (setType.isRawType()) {
                this.report.addError(MultibindsMethodValidator.this.bindingMethods("return type cannot be a raw Set type", new Object[0]));
            } else if (XTypes.isWildcard(setType.elementType())) {
                this.report.addError(MultibindsMethodValidator.this.bindingMethods("return type cannot use a wildcard as the Set value type.", new Object[0]));
            } else if (FrameworkTypes.isFrameworkType(setType.elementType())) {
                String frameworkTypeName = XElements.getSimpleName((XMemberContainer)setType.elementType().getTypeElement());
                this.report.addError(MultibindsMethodValidator.this.bindingMethods("return type cannot use '%s' in the Set value type.", frameworkTypeName));
            }
        }
    }
}

