/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.writing;

import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import dagger.internal.codegen.base.SourceFileGenerator;
import dagger.internal.codegen.binding.AnnotationExpression;
import dagger.internal.codegen.javapoet.CodeBlocks;
import dagger.internal.codegen.javapoet.TypeNames;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.internal.codegen.xprocessing.XTypes;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XFiler;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XMethodElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XProcessingEnv;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XType;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XTypeElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XTypeKt;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.compat.XConverters;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.inject.Inject;
import javax.lang.model.element.Modifier;

public class AnnotationCreatorGenerator
extends SourceFileGenerator<XTypeElement> {
    private static final ClassName AUTO_ANNOTATION = ClassName.get((String)"com.google.auto.value", (String)"AutoAnnotation", (String[])new String[0]);

    @Inject
    AnnotationCreatorGenerator(XFiler filer, XProcessingEnv processingEnv) {
        super(filer, processingEnv);
    }

    @Override
    public XElement originatingElement(XTypeElement annotationType) {
        return annotationType;
    }

    @Override
    public ImmutableList<TypeSpec.Builder> topLevelTypes(XTypeElement annotationType) {
        ClassName generatedTypeName = AnnotationExpression.getAnnotationCreatorClassName(annotationType);
        TypeSpec.Builder annotationCreatorBuilder = TypeSpec.classBuilder((ClassName)generatedTypeName).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE}).build());
        for (XTypeElement annotationElement : this.annotationsToCreate(annotationType)) {
            annotationCreatorBuilder.addMethod(this.buildCreateMethod(generatedTypeName, annotationElement));
        }
        return ImmutableList.of((Object)annotationCreatorBuilder);
    }

    private MethodSpec buildCreateMethod(ClassName generatedTypeName, XTypeElement annotationElement) {
        String createMethodName = AnnotationExpression.createMethodName(annotationElement);
        MethodSpec.Builder createMethod = MethodSpec.methodBuilder((String)createMethodName).addAnnotation(AUTO_ANNOTATION).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns(annotationElement.getType().getTypeName());
        ImmutableList.Builder parameters = ImmutableList.builder();
        for (XMethodElement annotationMember : annotationElement.getDeclaredMethods()) {
            String parameterName = XElements.getSimpleName((XElement)annotationMember);
            TypeName parameterType = this.maybeRewrapKClass(annotationMember.getReturnType()).getTypeName();
            createMethod.addParameter(parameterType, parameterName, new Modifier[0]);
            parameters.add((Object)CodeBlock.of((String)"$L", (Object[])new Object[]{parameterName}));
        }
        ClassName autoAnnotationClass = generatedTypeName.peerClass("AutoAnnotation_" + generatedTypeName.simpleName() + "_" + createMethodName);
        createMethod.addStatement("return new $T($L)", new Object[]{autoAnnotationClass, CodeBlocks.makeParametersCodeBlock((Iterable<CodeBlock>)parameters.build())});
        return createMethod.build();
    }

    protected Set<XTypeElement> annotationsToCreate(XTypeElement annotationElement) {
        return AnnotationCreatorGenerator.nestedAnnotationElements(annotationElement, new LinkedHashSet<XTypeElement>());
    }

    @CanIgnoreReturnValue
    private static Set<XTypeElement> nestedAnnotationElements(XTypeElement annotationElement, Set<XTypeElement> annotationElements) {
        if (annotationElements.add(annotationElement)) {
            for (XMethodElement method : annotationElement.getDeclaredMethods()) {
                XType returnType = method.getReturnType();
                XTypeElement maybeAnnotationType = XTypeKt.isArray((XType)returnType) ? XTypes.asArray(returnType).getComponentType().getTypeElement() : returnType.getTypeElement();
                if (maybeAnnotationType == null || !maybeAnnotationType.isAnnotationClass()) continue;
                AnnotationCreatorGenerator.nestedAnnotationElements(maybeAnnotationType, annotationElements);
            }
        }
        return annotationElements;
    }

    private XType maybeRewrapKClass(XType type) {
        return XTypeKt.isArray((XType)type) ? XConverters.getProcessingEnv((XType)type).getArrayType(this.maybeRewrapKClass(XTypes.asArray(type).getComponentType())) : (XTypes.isTypeOf(type, TypeNames.KCLASS) ? XTypes.rewrapType(type, TypeNames.CLASS) : type);
    }
}

