/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.writing;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.TypeName;
import dagger.assisted.Assisted;
import dagger.assisted.AssistedFactory;
import dagger.assisted.AssistedInject;
import dagger.internal.codegen.binding.AssistedInjectionBinding;
import dagger.internal.codegen.binding.ComponentRequirement;
import dagger.internal.codegen.binding.ContributionBinding;
import dagger.internal.codegen.binding.InjectionBinding;
import dagger.internal.codegen.compileroption.CompilerOptions;
import dagger.internal.codegen.javapoet.CodeBlocks;
import dagger.internal.codegen.javapoet.Expression;
import dagger.internal.codegen.javapoet.TypeNames;
import dagger.internal.codegen.langmodel.Accessibility;
import dagger.internal.codegen.model.BindingKind;
import dagger.internal.codegen.model.DependencyRequest;
import dagger.internal.codegen.writing.ComponentImplementation;
import dagger.internal.codegen.writing.ComponentRequestRepresentations;
import dagger.internal.codegen.writing.ComponentRequirementExpressions;
import dagger.internal.codegen.writing.InjectionMethods;
import dagger.internal.codegen.writing.MembersInjectionMethods;
import dagger.internal.codegen.writing.RequestRepresentation;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.internal.codegen.xprocessing.XProcessingEnvs;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XElementKt;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XExecutableElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XProcessingEnv;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XType;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XTypeElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XVariableElement;
import java.util.Optional;

final class SimpleMethodRequestRepresentation
extends RequestRepresentation {
    private static final ImmutableSet<BindingKind> VALID_BINDING_KINDS = ImmutableSet.of((Object)((Object)BindingKind.INJECTION), (Object)((Object)BindingKind.ASSISTED_INJECTION), (Object)((Object)BindingKind.PROVISION));
    private final CompilerOptions compilerOptions;
    private final XProcessingEnv processingEnv;
    private final ContributionBinding binding;
    private final ComponentRequestRepresentations componentRequestRepresentations;
    private final MembersInjectionMethods membersInjectionMethods;
    private final ComponentRequirementExpressions componentRequirementExpressions;
    private final ComponentImplementation.ShardImplementation shardImplementation;

    @AssistedInject
    SimpleMethodRequestRepresentation(@Assisted ContributionBinding binding, MembersInjectionMethods membersInjectionMethods, CompilerOptions compilerOptions, XProcessingEnv processingEnv, ComponentRequestRepresentations componentRequestRepresentations, ComponentRequirementExpressions componentRequirementExpressions, ComponentImplementation componentImplementation) {
        this.compilerOptions = compilerOptions;
        this.processingEnv = processingEnv;
        this.binding = binding;
        Preconditions.checkArgument((boolean)VALID_BINDING_KINDS.contains((Object)binding.kind()));
        Preconditions.checkArgument((boolean)binding.bindingElement().isPresent());
        this.componentRequestRepresentations = componentRequestRepresentations;
        this.membersInjectionMethods = membersInjectionMethods;
        this.componentRequirementExpressions = componentRequirementExpressions;
        this.shardImplementation = componentImplementation.shardImplementation(binding);
    }

    @Override
    Expression getDependencyExpression(ClassName requestingClass) {
        return this.requiresInjectionMethod(requestingClass) ? this.invokeInjectionMethod(requestingClass) : this.invokeMethod(requestingClass);
    }

    private Expression invokeMethod(ClassName requestingClass) {
        CodeBlock invocation;
        CodeBlock arguments = CodeBlocks.makeParametersCodeBlock(InjectionMethods.ProvisionMethod.invokeArguments(this.binding, request -> this.dependencyArgument((DependencyRequest)request, requestingClass).codeBlock(), this.shardImplementation::getUniqueFieldNameForAssistedParam));
        XElement bindingElement = this.binding.bindingElement().get();
        XTypeElement bindingTypeElement = this.binding.bindingTypeElement().get();
        if (XElementKt.isConstructor((XElement)bindingElement)) {
            invocation = CodeBlock.of((String)"new $T($L)", (Object[])new Object[]{this.constructorTypeName(requestingClass), arguments});
        } else if (XElementKt.isMethod((XElement)bindingElement)) {
            Optional<CodeBlock> requiredModuleInstance = this.moduleReference(requestingClass);
            CodeBlock module = requiredModuleInstance.isPresent() ? requiredModuleInstance.get() : (bindingTypeElement.isKotlinObject() && !bindingTypeElement.isCompanionObject() ? CodeBlock.of((String)"$T.INSTANCE", (Object[])new Object[]{bindingTypeElement.getClassName()}) : CodeBlock.of((String)"$T", (Object[])new Object[]{bindingTypeElement.getClassName()}));
            invocation = CodeBlock.of((String)"$L.$L($L)", (Object[])new Object[]{module, XElements.asMethod(bindingElement).getJvmName(), arguments});
        } else {
            throw new AssertionError((Object)("Unexpected binding element: " + bindingElement));
        }
        return Expression.create(this.simpleMethodReturnType(), invocation);
    }

    private TypeName constructorTypeName(ClassName requestingClass) {
        XType type = this.binding.key().type().xprocessing();
        return type.getTypeArguments().stream().allMatch(t -> Accessibility.isTypeAccessibleFrom(t, requestingClass.packageName())) ? type.getTypeName() : TypeNames.rawTypeName(type.getTypeName());
    }

    private Expression invokeInjectionMethod(ClassName requestingClass) {
        return this.injectMembers(InjectionMethods.ProvisionMethod.invoke(this.binding, request -> this.dependencyArgument((DependencyRequest)request, requestingClass).codeBlock(), this.shardImplementation::getUniqueFieldNameForAssistedParam, requestingClass, this.moduleReference(requestingClass), this.compilerOptions), requestingClass);
    }

    private Expression dependencyArgument(DependencyRequest dependency, ClassName requestingClass) {
        return this.componentRequestRepresentations.getDependencyArgumentExpression(dependency, requestingClass);
    }

    private Expression injectMembers(CodeBlock instance, ClassName requestingClass) {
        if (!SimpleMethodRequestRepresentation.hasInjectionSites(this.binding)) {
            return Expression.create(this.simpleMethodReturnType(), instance);
        }
        if (XProcessingEnvs.isPreJava8SourceVersion(this.processingEnv) && !this.binding.key().type().xprocessing().getTypeArguments().isEmpty()) {
            TypeName keyType = this.binding.key().type().xprocessing().getTypeName();
            instance = CodeBlock.of((String)"($T) ($T) $L", (Object[])new Object[]{keyType, TypeNames.rawTypeName(keyType), instance});
        }
        return this.membersInjectionMethods.getInjectExpression(this.binding.key(), instance, requestingClass);
    }

    private Optional<CodeBlock> moduleReference(ClassName requestingClass) {
        return this.binding.requiresModuleInstance() ? this.binding.contributingModule().map(XTypeElement::getType).map(ComponentRequirement::forModule).map(module -> this.componentRequirementExpressions.getExpression((ComponentRequirement)module, requestingClass)) : Optional.empty();
    }

    private XType simpleMethodReturnType() {
        return this.binding.contributedPrimitiveType().orElse(this.binding.key().type().xprocessing());
    }

    private boolean requiresInjectionMethod(ClassName requestingClass) {
        XExecutableElement executableElement = XElements.asExecutable(this.binding.bindingElement().get());
        return SimpleMethodRequestRepresentation.hasInjectionSites(this.binding) || this.binding.shouldCheckForNull(this.compilerOptions) || !Accessibility.isElementAccessibleFrom((XElement)executableElement, requestingClass.packageName()) || executableElement.getParameters().stream().map(XVariableElement::getType).anyMatch(type -> !Accessibility.isRawTypeAccessible(type, requestingClass.packageName()));
    }

    private static boolean hasInjectionSites(ContributionBinding binding) {
        switch (binding.kind()) {
            case INJECTION: {
                return !((InjectionBinding)binding).injectionSites().isEmpty();
            }
            case ASSISTED_INJECTION: {
                return !((AssistedInjectionBinding)binding).injectionSites().isEmpty();
            }
            case PROVISION: {
                return false;
            }
        }
        throw new AssertionError((Object)("Unexpected binding kind: " + (Object)((Object)binding.kind())));
    }

    @AssistedFactory
    static interface Factory {
        public SimpleMethodRequestRepresentation create(ContributionBinding var1);
    }
}

