/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.bindinggraphvalidation;

import dagger.internal.codegen.model.Binding;
import dagger.internal.codegen.model.BindingGraph;
import dagger.internal.codegen.model.DiagnosticReporter;
import dagger.internal.codegen.validation.ValidationBindingGraphPlugin;
import javax.inject.Inject;
import javax.tools.Diagnostic;

final class InvalidProductionBindingScopeValidator
extends ValidationBindingGraphPlugin {
    @Inject
    InvalidProductionBindingScopeValidator() {
    }

    @Override
    public String pluginName() {
        return "Dagger/InvalidProductionBindingScope";
    }

    @Override
    public void visitGraph(BindingGraph bindingGraph, DiagnosticReporter reporter) {
        bindingGraph.bindings().stream().filter(Binding::isProduction).filter(binding -> binding.scope().isPresent()).forEach(binding -> reporter.reportBinding(Diagnostic.Kind.ERROR, (BindingGraph.MaybeBinding)binding, this.errorMessage((Binding)binding)));
    }

    private String errorMessage(Binding binding) {
        return String.format("%s cannot be scoped because it delegates to an @Produces method.", binding);
    }
}

