/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.componentgenerator;

import com.google.common.base.Ascii;
import com.google.common.base.CaseFormat;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import dagger.internal.codegen.base.ComponentCreatorKind;
import dagger.internal.codegen.base.SourceFileGenerator;
import dagger.internal.codegen.binding.ComponentCreatorDescriptor;
import dagger.internal.codegen.binding.ComponentDescriptor;
import dagger.internal.codegen.binding.ComponentRequirement;
import dagger.internal.codegen.binding.MethodSignature;
import dagger.internal.codegen.compileroption.CompilerOptions;
import dagger.internal.codegen.langmodel.Accessibility;
import dagger.internal.codegen.writing.ComponentNames;
import dagger.internal.codegen.xprocessing.MethodSpecs;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.internal.codegen.xprocessing.XTypeElements;
import dagger.internal.codegen.xprocessing.XTypeNames;
import dagger.internal.codegen.xprocessing.XTypeSpecs;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XClassName;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XTypeName;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XTypeSpec;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.compat.XConverters;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XExecutableParameterElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XFiler;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XMemberContainer;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XMethodElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XProcessingEnv;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XType;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XTypeElement;
import java.util.HashSet;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.lang.model.element.Modifier;

final class ComponentHjarGenerator
extends SourceFileGenerator<ComponentDescriptor> {
    private final XProcessingEnv processingEnv;
    private final CompilerOptions compilerOptions;

    @Inject
    ComponentHjarGenerator(XFiler filer, XProcessingEnv processingEnv, CompilerOptions compilerOptions) {
        super(filer, processingEnv);
        this.processingEnv = processingEnv;
        this.compilerOptions = compilerOptions;
    }

    @Override
    public XElement originatingElement(ComponentDescriptor input) {
        return input.typeElement();
    }

    @Override
    public ImmutableList<XTypeSpec> topLevelTypes(ComponentDescriptor componentDescriptor) {
        boolean noArgFactoryMethod;
        ComponentCreatorKind creatorKind;
        XClassName builderMethodReturnType;
        XClassName generatedTypeName = ComponentNames.getTopLevelClassName(componentDescriptor);
        XTypeSpecs.Builder generatedComponent = XTypeSpecs.classBuilder(generatedTypeName).addModifiers(Modifier.FINAL).addMethod(ComponentHjarGenerator.privateConstructor());
        if (componentDescriptor.typeElement().isPublic()) {
            generatedComponent.addModifiers(Modifier.PUBLIC);
        }
        XTypeElement componentElement = componentDescriptor.typeElement();
        if (this.compilerOptions.generatedClassExtendsComponent()) {
            generatedComponent.superType(componentElement);
        }
        if (componentDescriptor.creatorDescriptor().isPresent()) {
            ComponentCreatorDescriptor creatorDescriptor = componentDescriptor.creatorDescriptor().get();
            builderMethodReturnType = creatorDescriptor.typeElement().asClassName();
            creatorKind = creatorDescriptor.kind();
            noArgFactoryMethod = creatorDescriptor.factoryParameters().isEmpty();
        } else {
            XClassName builderClassName;
            XTypeSpecs.Builder builder = XTypeSpecs.classBuilder("Builder").addModifiers(Modifier.STATIC, Modifier.FINAL).addMethod(ComponentHjarGenerator.privateConstructor());
            if (componentDescriptor.typeElement().isPublic()) {
                builder.addModifiers(Modifier.PUBLIC);
            }
            builderMethodReturnType = builderClassName = generatedTypeName.nestedClass("Builder");
            creatorKind = ComponentCreatorKind.BUILDER;
            noArgFactoryMethod = true;
            ComponentHjarGenerator.componentRequirements(componentDescriptor).map(requirement -> ComponentHjarGenerator.builderSetterMethod(requirement.typeElement(), builderClassName)).forEach(builder::addMethod);
            builder.addMethod(ComponentHjarGenerator.builderBuildMethod(componentDescriptor));
            generatedComponent.addType(builder.build());
        }
        generatedComponent.addMethod(ComponentHjarGenerator.staticCreatorMethod((XTypeName)builderMethodReturnType, creatorKind));
        if (noArgFactoryMethod && !this.hasBindsInstanceMethods(componentDescriptor) && ComponentHjarGenerator.componentRequirements(componentDescriptor).noneMatch(ComponentRequirement::requiresAPassedInstance)) {
            generatedComponent.addMethod(ComponentHjarGenerator.createMethod(componentDescriptor));
        }
        if (this.compilerOptions.generatedClassExtendsComponent()) {
            XType componentType = componentElement.getType();
            HashSet methodSignatures = Sets.newHashSetWithExpectedSize((int)componentDescriptor.componentMethods().size());
            componentDescriptor.componentMethods().stream().filter(method -> methodSignatures.add(MethodSignature.forComponentMethod(method, componentType, this.processingEnv))).forEach(method -> generatedComponent.addMethod(this.emptyComponentMethod(componentElement, method.methodElement())));
            if (componentDescriptor.isProduction()) {
                generatedComponent.addSuperinterface((XTypeName)XTypeNames.CANCELLATION_LISTENER).addMethod(ComponentHjarGenerator.onProducerFutureCancelledMethod());
            }
        }
        return ImmutableList.of((Object)generatedComponent.build());
    }

    private MethodSpec emptyComponentMethod(XTypeElement typeElement, XMethodElement baseMethod) {
        return MethodSpecs.overriding(baseMethod, typeElement.getType()).build();
    }

    private static MethodSpec privateConstructor() {
        return MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE}).build();
    }

    private static Stream<ComponentRequirement> componentRequirements(ComponentDescriptor component) {
        Preconditions.checkArgument((!component.isSubcomponent() ? 1 : 0) != 0);
        return Stream.concat(component.dependencies().stream(), component.modules().stream().filter(module -> !module.moduleElement().isAbstract() && Accessibility.isElementAccessibleFrom((XElement)module.moduleElement(), component.typeElement().getClassName().packageName())).map(module -> ComponentRequirement.forModule(module.moduleElement().getType())).filter(requirement -> component.creatorDescriptor().isPresent() || requirement.requiresModuleInstance()));
    }

    private boolean hasBindsInstanceMethods(ComponentDescriptor componentDescriptor) {
        return componentDescriptor.creatorDescriptor().isPresent() && XTypeElements.getAllUnimplementedMethods(componentDescriptor.creatorDescriptor().get().typeElement()).stream().anyMatch(method -> ComponentHjarGenerator.isBindsInstance(method));
    }

    private static boolean isBindsInstance(XMethodElement method) {
        return method.hasAnnotation(XTypeNames.BINDS_INSTANCE) || method.getParameters().size() == 1 && ((XExecutableParameterElement)Iterables.getOnlyElement((Iterable)method.getParameters())).hasAnnotation(XTypeNames.BINDS_INSTANCE);
    }

    private static MethodSpec builderSetterMethod(XTypeElement componentRequirement, XClassName builderClass) {
        String simpleName = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, XElements.getSimpleName((XMemberContainer)componentRequirement));
        return MethodSpec.methodBuilder((String)simpleName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)componentRequirement.getClassName(), simpleName, new Modifier[0]).returns((TypeName)XConverters.toJavaPoet((XClassName)builderClass)).build();
    }

    private static MethodSpec builderBuildMethod(ComponentDescriptor component) {
        return MethodSpec.methodBuilder((String)"build").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)component.typeElement().getClassName()).build();
    }

    private static MethodSpec staticCreatorMethod(XTypeName creatorMethodReturnType, ComponentCreatorKind creatorKind) {
        return MethodSpec.methodBuilder((String)Ascii.toLowerCase((String)creatorKind.typeName())).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns(XConverters.toJavaPoet((XTypeName)creatorMethodReturnType)).build();
    }

    private static MethodSpec createMethod(ComponentDescriptor componentDescriptor) {
        return MethodSpec.methodBuilder((String)"create").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns((TypeName)componentDescriptor.typeElement().getClassName()).build();
    }

    private static MethodSpec onProducerFutureCancelledMethod() {
        return MethodSpec.methodBuilder((String)"onProducerFutureCancelled").addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(TypeName.BOOLEAN, "mayInterruptIfRunning", new Modifier[0]).build();
    }
}

