/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.writing;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import dagger.assisted.Assisted;
import dagger.assisted.AssistedFactory;
import dagger.assisted.AssistedInject;
import dagger.internal.codegen.base.MapType;
import dagger.internal.codegen.binding.BindingGraph;
import dagger.internal.codegen.binding.BindingRequest;
import dagger.internal.codegen.binding.ContributionBinding;
import dagger.internal.codegen.binding.MapKeys;
import dagger.internal.codegen.binding.MultiboundMapBinding;
import dagger.internal.codegen.langmodel.Accessibility;
import dagger.internal.codegen.model.BindingKind;
import dagger.internal.codegen.model.DependencyRequest;
import dagger.internal.codegen.writing.ComponentImplementation;
import dagger.internal.codegen.writing.ComponentRequestRepresentations;
import dagger.internal.codegen.writing.RequestRepresentation;
import dagger.internal.codegen.xprocessing.XCodeBlocks;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.internal.codegen.xprocessing.XExpression;
import dagger.internal.codegen.xprocessing.XTypeNames;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XClassName;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XCodeBlock;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XTypeName;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.compat.XConverters;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XProcessingEnv;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XType;

final class MapRequestRepresentation
extends RequestRepresentation {
    private static final int MAX_IMMUTABLE_MAP_OF_KEY_VALUE_PAIRS = 5;
    private final XProcessingEnv processingEnv;
    private final MultiboundMapBinding binding;
    private final ImmutableMap<DependencyRequest, ContributionBinding> dependencies;
    private final ComponentRequestRepresentations componentRequestRepresentations;
    private final boolean useLazyClassKey;

    @AssistedInject
    MapRequestRepresentation(@Assisted MultiboundMapBinding binding, XProcessingEnv processingEnv, BindingGraph graph, ComponentImplementation componentImplementation, ComponentRequestRepresentations componentRequestRepresentations) {
        this.binding = binding;
        this.processingEnv = processingEnv;
        BindingKind bindingKind = this.binding.kind();
        Preconditions.checkArgument((boolean)bindingKind.equals((Object)BindingKind.MULTIBOUND_MAP), (Object)((Object)bindingKind));
        this.componentRequestRepresentations = componentRequestRepresentations;
        this.dependencies = Maps.toMap(binding.dependencies(), dep -> graph.contributionBinding(dep.key()));
        this.useLazyClassKey = MapKeys.useLazyClassKey(binding, graph);
    }

    @Override
    XExpression getDependencyExpression(XClassName requestingClass) {
        MapType mapType = MapType.from(this.binding.key());
        XExpression dependencyExpression = this.getUnderlyingMapExpression(requestingClass);
        if (this.useLazyClassKey) {
            return XExpression.create(dependencyExpression.type(), XCodeBlock.of((String)"%T.<%T>of(%L)", (Object[])new Object[]{XTypeNames.LAZY_CLASS_KEY_MAP, mapType.valueType().asTypeName(), dependencyExpression.codeBlock()}));
        }
        return dependencyExpression;
    }

    private XExpression getUnderlyingMapExpression(XClassName requestingClass) {
        boolean isImmutableMapAvailable = this.isImmutableMapAvailable();
        if (isImmutableMapAvailable && this.dependencies.size() <= 5) {
            return XExpression.create(this.immutableMapType(), XCodeBlock.builder().add("%T.", new Object[]{XTypeNames.IMMUTABLE_MAP}).add(this.maybeTypeParameters(requestingClass)).add("of(%L)", new Object[]{this.dependencies.keySet().stream().map(dependency -> this.keyAndValueExpression((DependencyRequest)dependency, requestingClass)).collect(XCodeBlocks.toParametersCodeBlock())}).build());
        }
        switch (this.dependencies.size()) {
            case 0: {
                return this.collectionsStaticFactoryInvocation(requestingClass, XCodeBlock.of((String)"emptyMap()", (Object[])new Object[0]));
            }
            case 1: {
                return this.collectionsStaticFactoryInvocation(requestingClass, XCodeBlock.of((String)"singletonMap(%L)", (Object[])new Object[]{this.keyAndValueExpression((DependencyRequest)Iterables.getOnlyElement((Iterable)this.dependencies.keySet()), requestingClass)}));
            }
        }
        XCodeBlock.Builder instantiation = XCodeBlock.builder().add("%T.", new Object[]{isImmutableMapAvailable ? XTypeNames.IMMUTABLE_MAP : XTypeNames.MAP_BUILDER}).add(this.maybeTypeParameters(requestingClass));
        if (this.isImmutableMapBuilderWithExpectedSizeAvailable()) {
            instantiation.add("builderWithExpectedSize(%L)", new Object[]{this.dependencies.size()});
        } else if (isImmutableMapAvailable) {
            instantiation.add("builder()", new Object[0]);
        } else {
            instantiation.add("newMapBuilder(%L)", new Object[]{this.dependencies.size()});
        }
        for (DependencyRequest dependency2 : this.dependencies.keySet()) {
            instantiation.add(".put(%L)", new Object[]{this.keyAndValueExpression(dependency2, requestingClass)});
        }
        return XExpression.create(isImmutableMapAvailable ? this.immutableMapType() : this.binding.key().type().xprocessing(), instantiation.add(".build()", new Object[0]).build());
    }

    private XType immutableMapType() {
        MapType mapType = MapType.from(this.binding.key());
        return this.processingEnv.getDeclaredType(this.processingEnv.requireTypeElement((XTypeName)XTypeNames.IMMUTABLE_MAP), new XType[]{mapType.keyType(), mapType.valueType()});
    }

    private XCodeBlock keyAndValueExpression(DependencyRequest dependency, XClassName requestingClass) {
        return XCodeBlock.of((String)"%L, %L", (Object[])new Object[]{this.useLazyClassKey ? MapKeys.getLazyClassMapKeyExpression((ContributionBinding)this.dependencies.get((Object)dependency)) : MapKeys.getMapKeyExpression((ContributionBinding)this.dependencies.get((Object)dependency), requestingClass, this.processingEnv), this.componentRequestRepresentations.getDependencyExpression(BindingRequest.bindingRequest(dependency), requestingClass).codeBlock()});
    }

    private XExpression collectionsStaticFactoryInvocation(XClassName requestingClass, XCodeBlock methodInvocation) {
        return XExpression.create(this.binding.key().type().xprocessing(), XConverters.toJavaPoet((XCodeBlock)XCodeBlock.builder().add("%T.", new Object[]{XTypeNames.COLLECTIONS}).add(this.maybeTypeParameters(requestingClass)).add(methodInvocation).build()));
    }

    private XCodeBlock maybeTypeParameters(XClassName requestingClass) {
        XType bindingKeyType = this.binding.key().type().xprocessing();
        MapType mapType = MapType.from(this.binding.key());
        return Accessibility.isTypeAccessibleFrom(bindingKeyType, requestingClass.getPackageName()) ? XCodeBlock.of((String)"<%T, %T>", (Object[])new Object[]{this.useLazyClassKey ? XTypeName.STRING : mapType.keyType().asTypeName(), mapType.valueType().asTypeName()}) : XCodeBlock.of((String)"", (Object[])new Object[0]);
    }

    private boolean isImmutableMapBuilderWithExpectedSizeAvailable() {
        return this.isImmutableMapAvailable() && this.processingEnv.requireTypeElement((XTypeName)XTypeNames.IMMUTABLE_MAP).getDeclaredMethods().stream().anyMatch(method -> XElements.getSimpleName((XElement)method).contentEquals("builderWithExpectedSize"));
    }

    private boolean isImmutableMapAvailable() {
        return this.processingEnv.findTypeElement((XTypeName)XTypeNames.IMMUTABLE_MAP) != null;
    }

    @AssistedFactory
    static interface Factory {
        public MapRequestRepresentation create(MultiboundMapBinding var1);
    }
}

