/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.writing;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import dagger.assisted.Assisted;
import dagger.assisted.AssistedFactory;
import dagger.assisted.AssistedInject;
import dagger.internal.codegen.binding.MembersInjectionBinding;
import dagger.internal.codegen.binding.MembersInjectorBinding;
import dagger.internal.codegen.binding.SourceFiles;
import dagger.internal.codegen.writing.ComponentImplementation;
import dagger.internal.codegen.writing.ComponentRequestRepresentations;
import dagger.internal.codegen.writing.FrameworkFieldInitializer;
import dagger.internal.codegen.xprocessing.XTypeNames;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XCodeBlock;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XTypeName;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XType;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XTypeElement;

final class MembersInjectorProviderCreationExpression
implements FrameworkFieldInitializer.FrameworkInstanceCreationExpression {
    private final ComponentImplementation.ShardImplementation shardImplementation;
    private final ComponentRequestRepresentations componentRequestRepresentations;
    private final MembersInjectorBinding binding;

    @AssistedInject
    MembersInjectorProviderCreationExpression(@Assisted MembersInjectorBinding binding, ComponentImplementation componentImplementation, ComponentRequestRepresentations componentRequestRepresentations) {
        this.binding = (MembersInjectorBinding)Preconditions.checkNotNull((Object)binding);
        this.shardImplementation = componentImplementation.shardImplementation(binding);
        this.componentRequestRepresentations = (ComponentRequestRepresentations)Preconditions.checkNotNull((Object)componentRequestRepresentations);
    }

    @Override
    public XCodeBlock creationExpression() {
        XCodeBlock membersInjector;
        XType membersInjectedType = (XType)Iterables.getOnlyElement((Iterable)this.binding.key().type().xprocessing().getTypeArguments());
        boolean castThroughRawType = false;
        if (this.binding.injectionSites().isEmpty()) {
            membersInjector = XCodeBlock.of((String)"%T.<%T>noOp()", (Object[])new Object[]{XTypeNames.MEMBERS_INJECTORS, membersInjectedType.asTypeName()});
        } else {
            XTypeElement injectedTypeElement = membersInjectedType.getTypeElement();
            while (!this.hasLocalInjectionSites(injectedTypeElement)) {
                castThroughRawType = true;
                injectedTypeElement = injectedTypeElement.getSuperType().getTypeElement();
            }
            membersInjector = XCodeBlock.of((String)"%T.create(%L)", (Object[])new Object[]{SourceFiles.membersInjectorNameForType(injectedTypeElement), this.componentRequestRepresentations.getCreateMethodArgumentsCodeBlock(this.binding, this.shardImplementation.name())});
        }
        XCodeBlock providerExpression = XCodeBlock.of((String)"%T.create(%L)", (Object[])new Object[]{XTypeNames.INSTANCE_FACTORY, membersInjector});
        return castThroughRawType ? XCodeBlock.ofCast((XTypeName)XTypeNames.INSTANCE_FACTORY, (XCodeBlock)providerExpression) : providerExpression;
    }

    private boolean hasLocalInjectionSites(XTypeElement injectedTypeElement) {
        return this.binding.injectionSites().stream().map(MembersInjectionBinding.InjectionSite::enclosingTypeElement).anyMatch(arg_0 -> ((XTypeElement)injectedTypeElement).equals(arg_0));
    }

    @AssistedFactory
    static interface Factory {
        public MembersInjectorProviderCreationExpression create(MembersInjectorBinding var1);
    }
}

