/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.xprocessing;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.kotlinpoet.KModifier;
import dagger.internal.codegen.xprocessing.Nullability;
import dagger.internal.codegen.xprocessing.XTypeNames;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XAnnotationSpec;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XClassName;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XParameterSpec;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XTypeName;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.compat.XConverters;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XExecutableParameterElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.lang.model.element.Modifier;

public final class XParameterSpecs {
    public static XParameterSpec parameterSpecOf(XExecutableParameterElement parameter) {
        return XParameterSpecs.builder(parameter.getJvmName(), parameter.getType().asTypeName()).build();
    }

    public static XParameterSpec parameterSpecOf(XExecutableParameterElement parameter, XType parameterType) {
        Nullability nullability = Nullability.of((XElement)parameter);
        return XParameterSpecs.builder(parameter.getJvmName(), XTypeNames.withTypeNullability(parameterType.asTypeName(), nullability)).addAnnotationNames((Collection<XClassName>)nullability.nonTypeUseNullableAnnotations()).build();
    }

    public static XParameterSpec of(String name, XTypeName typeName, Nullability nullability) {
        return XParameterSpecs.builder(name, typeName, nullability).build();
    }

    public static XParameterSpec of(String name, XTypeName typeName) {
        return XParameterSpecs.builder(name, typeName).build();
    }

    public static Builder builder(String name, XTypeName typeName, Nullability nullability) {
        return new Builder(name, XTypeNames.withTypeNullability(typeName, nullability)).addAnnotationNames((Collection<XClassName>)nullability.nonTypeUseNullableAnnotations());
    }

    public static Builder builder(String name, XTypeName typeName) {
        return new Builder(name, typeName);
    }

    private XParameterSpecs() {
    }

    public static class Builder {
        private final String name;
        private final XTypeName typeName;
        private Boolean isFinal = null;
        private final List<Object> annotations = new ArrayList<Object>();

        Builder(String name, XTypeName typeName) {
            this.name = name;
            this.typeName = typeName;
        }

        @CanIgnoreReturnValue
        public Builder addModifiers(Collection<Modifier> modifiers) {
            return this.addModifiers(modifiers.toArray(new Modifier[0]));
        }

        @CanIgnoreReturnValue
        public Builder addModifiers(Modifier ... modifiers) {
            block3: for (Modifier modifier : modifiers) {
                switch (modifier) {
                    case FINAL: {
                        this.isFinal = true;
                        continue block3;
                    }
                    default: {
                        throw new AssertionError((Object)("Unexpected modifier: " + (Object)((Object)modifier)));
                    }
                }
            }
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addAnnotations(Collection<XAnnotationSpec> annotations) {
            annotations.forEach(this::addAnnotation);
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        public Builder addJavaAnnotations(Collection<AnnotationSpec> annotations) {
            annotations.forEach(this::addAnnotation);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addAnnotationNames(Collection<XClassName> annotationNames) {
            annotationNames.forEach(this::addAnnotation);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addAnnotation(XAnnotationSpec annotation) {
            this.annotations.add(annotation);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addAnnotation(XClassName annotationName) {
            return this.addAnnotation(XAnnotationSpec.of((XClassName)annotationName));
        }

        @Deprecated
        @CanIgnoreReturnValue
        public Builder addAnnotation(Class<?> clazz) {
            this.addAnnotation(AnnotationSpec.builder((ClassName)ClassName.get(clazz)).build());
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        public Builder addAnnotation(AnnotationSpec annotation) {
            this.annotations.add(annotation);
            return this;
        }

        public XParameterSpec build() {
            XParameterSpec.Builder builder = XParameterSpec.builder((String)this.name, (XTypeName)this.typeName, (boolean)false);
            if (this.isFinal == null) {
                XConverters.toJavaPoet((XParameterSpec.Builder)builder).modifiers.remove((Object)Modifier.FINAL);
            } else if (!this.isFinal.booleanValue()) {
                XConverters.toJavaPoet((XParameterSpec.Builder)builder).modifiers.remove((Object)Modifier.FINAL);
                XConverters.toKotlinPoet((XParameterSpec.Builder)builder).getModifiers().remove(KModifier.FINAL);
            }
            for (Object annotation : this.annotations) {
                if (annotation instanceof XAnnotationSpec) {
                    builder.addAnnotation((XAnnotationSpec)annotation);
                    continue;
                }
                if (annotation instanceof AnnotationSpec) {
                    XConverters.toJavaPoet((XParameterSpec.Builder)builder).addAnnotation((AnnotationSpec)annotation);
                    continue;
                }
                throw new AssertionError((Object)("Unexpected annotation class: " + annotation.getClass()));
            }
            return builder.build();
        }
    }
}

