/*
 * Decompiled with CFR 0.152.
 */
package dagger.producers.internal;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import dagger.producers.Producer;
import dagger.producers.internal.AbstractMapProducer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.inject.Provider;

public final class MapProducer<K, V>
extends AbstractMapProducer<K, V, V> {
    private MapProducer(ImmutableMap<K, Producer<V>> contributingMap) {
        super(contributingMap);
    }

    public static <K, V> Builder<K, V> builder(int size) {
        return new Builder(size);
    }

    @Override
    protected ListenableFuture<Map<K, V>> compute() {
        ArrayList<ListenableFuture> listOfEntries = new ArrayList<ListenableFuture>();
        for (final Map.Entry entry : this.contributingMap().entrySet()) {
            listOfEntries.add(Futures.transform(((Producer)entry.getValue()).get(), (Function)new Function<V, Map.Entry<K, V>>(){

                public Map.Entry<K, V> apply(V computedValue) {
                    return Maps.immutableEntry(entry.getKey(), computedValue);
                }
            }, (Executor)MoreExecutors.directExecutor()));
        }
        return Futures.transform((ListenableFuture)Futures.allAsList(listOfEntries), (Function)new Function<List<Map.Entry<K, V>>, Map<K, V>>(){

            public Map<K, V> apply(List<Map.Entry<K, V>> entries) {
                return ImmutableMap.copyOf(entries);
            }
        }, (Executor)MoreExecutors.directExecutor());
    }

    public static final class Builder<K, V>
    extends AbstractMapProducer.Builder<K, V, V> {
        private Builder(int size) {
            super(size);
        }

        public Builder<K, V> put(K key, Producer<V> producerOfValue) {
            super.put(key, producerOfValue);
            return this;
        }

        public Builder<K, V> put(K key, Provider<V> providerOfValue) {
            super.put(key, providerOfValue);
            return this;
        }

        public Builder<K, V> putAll(Producer<Map<K, V>> mapProducer) {
            super.putAll(mapProducer);
            return this;
        }

        public MapProducer<K, V> build() {
            return new MapProducer(this.mapBuilder.build());
        }
    }
}

