/*
 * Decompiled with CFR 0.152.
 */
package dagger.model;

import com.google.common.base.CaseFormat;
import dagger.model.Key;

public enum RequestKind {
    INSTANCE,
    PROVIDER,
    LAZY,
    PROVIDER_OF_LAZY,
    MEMBERS_INJECTION,
    PRODUCER,
    PRODUCED,
    FUTURE;


    public String format(Key key) {
        switch (this) {
            case INSTANCE: {
                return key.toString();
            }
            case PROVIDER_OF_LAZY: {
                return String.format("Provider<Lazy<%s>>", key);
            }
            case MEMBERS_INJECTION: {
                return String.format("injectMembers(%s)", key);
            }
            case FUTURE: {
                return String.format("ListenableFuture<%s>", key);
            }
        }
        return String.format("%s<%s>", CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, this.name()), key);
    }
}

