/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.xprocessing;

import com.google.common.base.Equivalence;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import dagger.internal.codegen.xprocessing.XAnnotationValues;
import dagger.internal.codegen.xprocessing.XTypes;
import dagger.spi.shaded.androidx.room.compiler.processing.JavaPoetExtKt;
import dagger.spi.shaded.androidx.room.compiler.processing.XAnnotation;
import dagger.spi.shaded.androidx.room.compiler.processing.XProcessingEnv;
import dagger.spi.shaded.androidx.room.compiler.processing.compat.XConverters;
import dagger.spi.shaded.auto.common.AnnotationMirrors;
import java.util.Arrays;
import java.util.stream.Collectors;

public final class XAnnotations {
    private static final Equivalence<XAnnotation> XANNOTATION_EQUIVALENCE = new Equivalence<XAnnotation>(){

        protected boolean doEquivalent(XAnnotation left, XAnnotation right) {
            return XTypes.equivalence().equivalent((Object)left.getType(), (Object)right.getType()) && XAnnotationValues.equivalence().pairwise().equivalent(left.getAnnotationValues(), right.getAnnotationValues());
        }

        protected int doHash(XAnnotation annotation) {
            return Arrays.hashCode(new int[]{XTypes.equivalence().hash((Object)annotation.getType()), XAnnotationValues.equivalence().pairwise().hash(annotation.getAnnotationValues())});
        }

        public String toString() {
            return "XAnnotation.equivalence()";
        }
    };

    public static AnnotationSpec getAnnotationSpec(XAnnotation annotation) {
        return JavaPoetExtKt.toAnnotationSpec(annotation);
    }

    public static String toString(XAnnotation annotation) {
        return XConverters.getProcessingEnv(annotation).getBackend() == XProcessingEnv.Backend.JAVAC ? AnnotationMirrors.toString(XConverters.toJavac(annotation)) : XAnnotations.toStableString(annotation);
    }

    public static ClassName getClassName(XAnnotation annotation) {
        return annotation.getType().getTypeElement().getClassName();
    }

    public static Equivalence<XAnnotation> equivalence() {
        return XANNOTATION_EQUIVALENCE;
    }

    public static String toStableString(XAnnotation annotation) {
        try {
            if (annotation.getType().isError()) {
                return "@" + annotation.getName();
            }
            if (XConverters.getProcessingEnv(annotation).getBackend() == XProcessingEnv.Backend.KSP && annotation.getTypeElement().getConstructors().size() != 1) {
                return String.format("@%s", XAnnotations.getClassName(annotation).canonicalName());
            }
            return annotation.getAnnotationValues().isEmpty() ? String.format("@%s", XAnnotations.getClassName(annotation).canonicalName()) : String.format("@%s(%s)", XAnnotations.getClassName(annotation).canonicalName(), annotation.getAnnotationValues().stream().map(value2 -> {
                String name2 = value2.getName();
                String valueAsString = XAnnotationValues.toStableString(value2);
                return annotation.getAnnotationValues().size() == 1 && name2.contentEquals("value") ? valueAsString : String.format("%s=%s", name2, valueAsString);
            }).collect(Collectors.joining(", ")));
        }
        catch (TypeNotPresentException e) {
            return e.typeName();
        }
    }

    private XAnnotations() {
    }
}

