/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.android.internal.testing;

import android.app.Application;
import dagger.hilt.android.internal.testing.EarlySingletonComponentCreator;
import dagger.hilt.android.internal.testing.TestComponentData;
import dagger.hilt.android.internal.testing.TestComponentDataSupplier;
import dagger.hilt.android.internal.testing.TestInjector;
import dagger.hilt.android.testing.OnComponentReadyRunner;
import dagger.hilt.internal.GeneratedComponentManager;
import dagger.hilt.internal.Preconditions;
import dagger.hilt.internal.TestSingletonComponentManager;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.runner.Description;

public final class TestApplicationComponentManager
implements TestSingletonComponentManager,
OnComponentReadyRunner.OnComponentReadyRunnerHolder {
    private final Object earlyComponentLock = new Object();
    private volatile Object earlyComponent = null;
    private final Object testComponentDataLock = new Object();
    private volatile TestComponentData testComponentData;
    private final Application application;
    private final AtomicReference<Object> component = new AtomicReference();
    private final AtomicReference<Description> hasHiltTestRule = new AtomicReference();
    private final Map<Class<?>, Object> registeredModules = new ConcurrentHashMap();
    private final AtomicReference<Boolean> autoAddModuleEnabled = new AtomicReference();
    private final AtomicReference<DelayedComponentState> delayedComponentState = new AtomicReference<DelayedComponentState>(DelayedComponentState.NOT_DELAYED);
    private volatile Object testInstance;
    private volatile OnComponentReadyRunner onComponentReadyRunner = new OnComponentReadyRunner();

    public TestApplicationComponentManager(Application application) {
        this.application = application;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object earlySingletonComponent() {
        if (this.earlyComponent == null) {
            Object object = this.earlyComponentLock;
            synchronized (object) {
                if (this.earlyComponent == null) {
                    this.earlyComponent = EarlySingletonComponentCreator.createComponent(this.application);
                }
            }
        }
        return this.earlyComponent;
    }

    public Object generatedComponent() {
        if (this.component.get() == null) {
            Preconditions.checkState((boolean)this.hasHiltTestRule(), (String)"The component was not created. Check that you have added the HiltAndroidRule.", (Object[])new Object[0]);
            if (!this.registeredModules.keySet().containsAll(this.requiredModules())) {
                HashSet difference = new HashSet(this.requiredModules());
                difference.removeAll(this.registeredModules.keySet());
                throw new IllegalStateException("The component was not created. Check that you have registered all test modules:\n\tUnregistered: " + difference);
            }
            Preconditions.checkState((boolean)this.bindValueReady(), (String)"The test instance has not been set. Did you forget to call #bind()?", (Object[])new Object[0]);
            throw new IllegalStateException("The component has not been created. Check that you have called #inject()? Otherwise, there is a race between injection and component creation. Make sure there is a happens-before edge between the HiltAndroidRule/registering all test modules and the first injection.");
        }
        return this.component.get();
    }

    @Override
    public OnComponentReadyRunner getOnComponentReadyRunner() {
        return this.onComponentReadyRunner;
    }

    void setHasHiltTestRule(Description description) {
        Preconditions.checkState((boolean)this.hasHiltTestRule.compareAndSet(null, description), (String)"The hasHiltTestRule flag has already been set!", (Object[])new Object[0]);
        this.tryToCreateComponent();
    }

    void checkStateIsCleared() {
        Preconditions.checkState((this.component.get() == null ? 1 : 0) != 0, (String)"The Hilt component cannot be set before Hilt's test rule has run.", (Object[])new Object[0]);
        Preconditions.checkState((this.hasHiltTestRule.get() == null ? 1 : 0) != 0, (String)"The Hilt test rule cannot be set before Hilt's test rule has run.", (Object[])new Object[0]);
        Preconditions.checkState((this.autoAddModuleEnabled.get() == null ? 1 : 0) != 0, (String)"The Hilt autoAddModuleEnabled cannot be set before Hilt's test rule has run.", (Object[])new Object[0]);
        Preconditions.checkState((this.testInstance == null ? 1 : 0) != 0, (String)"The Hilt BindValue instance cannot be set before Hilt's test rule has run.", (Object[])new Object[0]);
        Preconditions.checkState((this.testComponentData == null ? 1 : 0) != 0, (String)"The testComponentData instance cannot be set before Hilt's test rule has run.", (Object[])new Object[0]);
        Preconditions.checkState((boolean)this.registeredModules.isEmpty(), (String)"The Hilt registered modules cannot be set before Hilt's test rule has run.", (Object[])new Object[0]);
        Preconditions.checkState((boolean)this.onComponentReadyRunner.isEmpty(), (String)"The Hilt onComponentReadyRunner cannot add listeners before Hilt's test rule has run.", (Object[])new Object[0]);
        DelayedComponentState state = this.delayedComponentState.get();
        switch (state.ordinal()) {
            case 0: 
            case 1: {
                break;
            }
            case 2: {
                throw new IllegalStateException("Called componentReady before test execution started");
            }
            case 3: {
                throw new IllegalStateException("Called inject before test execution started");
            }
        }
    }

    void clearState() {
        this.component.set(null);
        this.hasHiltTestRule.set(null);
        this.testInstance = null;
        this.testComponentData = null;
        this.registeredModules.clear();
        this.autoAddModuleEnabled.set(null);
        this.delayedComponentState.set(DelayedComponentState.NOT_DELAYED);
        this.onComponentReadyRunner = new OnComponentReadyRunner();
    }

    public Description getDescription() {
        return this.hasHiltTestRule.get();
    }

    public Object getTestInstance() {
        Preconditions.checkState((this.testInstance != null ? 1 : 0) != 0, (String)"The test instance has not been set.", (Object[])new Object[0]);
        return this.testInstance;
    }

    public <T> void registerModule(Class<T> moduleClass, T module) {
        Preconditions.checkNotNull(moduleClass);
        Preconditions.checkState((boolean)this.testComponentData().daggerRequiredModules().contains(moduleClass), (String)"Found unknown module class: %s", (Object[])new Object[]{moduleClass.getName()});
        if (this.requiredModules().contains(moduleClass)) {
            Preconditions.checkState((!this.registeredModules.containsKey(moduleClass) ? 1 : 0) != 0, (String)"Module is already registered: %s", (Object[])new Object[]{moduleClass.getName()});
            this.registeredModules.put(moduleClass, module);
            this.tryToCreateComponent();
        }
    }

    void delayComponentReady() {
        switch (this.delayedComponentState.getAndSet(DelayedComponentState.COMPONENT_DELAYED).ordinal()) {
            case 0: {
                break;
            }
            case 1: {
                throw new IllegalStateException("Called delayComponentReady() twice");
            }
            case 2: {
                throw new IllegalStateException("Called delayComponentReady() after componentReady()");
            }
            case 3: {
                throw new IllegalStateException("Called delayComponentReady() after inject()");
            }
        }
    }

    void componentReady() {
        switch (this.delayedComponentState.getAndSet(DelayedComponentState.COMPONENT_READY).ordinal()) {
            case 0: {
                throw new IllegalStateException("Called componentReady(), even though delayComponentReady() was not used.");
            }
            case 1: {
                break;
            }
            case 2: {
                throw new IllegalStateException("Called componentReady() multiple times");
            }
            case 3: {
                throw new IllegalStateException("Called componentReady() after inject()");
            }
        }
        this.tryToCreateComponent();
    }

    void inject() {
        switch (this.delayedComponentState.getAndSet(DelayedComponentState.INJECTED).ordinal()) {
            case 0: 
            case 2: {
                break;
            }
            case 1: {
                throw new IllegalStateException("Called inject() before calling componentReady()");
            }
            case 3: {
                throw new IllegalStateException("Called inject() multiple times");
            }
        }
        Preconditions.checkNotNull((Object)this.testInstance);
        this.testInjector().injectTest(this.testInstance);
    }

    void verifyDelayedComponentWasMadeReady() {
        Preconditions.checkState((this.delayedComponentState.get() != DelayedComponentState.COMPONENT_DELAYED ? 1 : 0) != 0, (String)"Used delayComponentReady(), but never called componentReady()", (Object[])new Object[0]);
    }

    private void tryToCreateComponent() {
        if (this.hasHiltTestRule() && this.registeredModules.keySet().containsAll(this.requiredModules()) && this.bindValueReady() && this.delayedComponentReady()) {
            Preconditions.checkState((this.autoAddModuleEnabled.get() != null ? 1 : 0) != 0, (String)"Component cannot be created before autoAddModuleEnabled is set.", (Object[])new Object[0]);
            Preconditions.checkState((boolean)this.component.compareAndSet(null, this.componentSupplier().get(this.registeredModules, this.testInstance, this.autoAddModuleEnabled.get())), (String)"Tried to create the component more than once! There is a race between registering the HiltAndroidRule and registering all test modules. Make sure there is a happens-before edge between the two.", (Object[])new Object[0]);
            this.onComponentReadyRunner.setComponentManager((GeneratedComponentManager)this.application);
        }
    }

    void setTestInstance(Object testInstance) {
        Preconditions.checkNotNull((Object)testInstance);
        Preconditions.checkState((this.testInstance == null ? 1 : 0) != 0, (String)"The test instance was already set!", (Object[])new Object[0]);
        this.testInstance = testInstance;
    }

    void setAutoAddModule(boolean autoAddModule) {
        Preconditions.checkState((boolean)this.autoAddModuleEnabled.compareAndSet(null, autoAddModule), (String)"autoAddModuleEnabled is already set!", (Object[])new Object[0]);
    }

    private Set<Class<?>> requiredModules() {
        return this.autoAddModuleEnabled.get() != false ? this.testComponentData().hiltRequiredModules() : this.testComponentData().daggerRequiredModules();
    }

    private boolean waitForBindValue() {
        return this.testComponentData().waitForBindValue();
    }

    private TestInjector<Object> testInjector() {
        return this.testComponentData().testInjector();
    }

    private TestComponentData.ComponentSupplier componentSupplier() {
        return this.testComponentData().componentSupplier();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TestComponentData testComponentData() {
        if (this.testComponentData == null) {
            Object object = this.testComponentDataLock;
            synchronized (object) {
                if (this.testComponentData == null) {
                    this.testComponentData = TestComponentDataSupplier.get(this.testClass());
                }
            }
        }
        return this.testComponentData;
    }

    private Class<?> testClass() {
        Preconditions.checkState((boolean)this.hasHiltTestRule(), (String)"Test must have a HiltAndroidRule.", (Object[])new Object[0]);
        return this.hasHiltTestRule.get().getTestClass();
    }

    private boolean bindValueReady() {
        return !this.waitForBindValue() || this.testInstance != null;
    }

    private boolean delayedComponentReady() {
        return this.delayedComponentState.get() != DelayedComponentState.COMPONENT_DELAYED;
    }

    private boolean hasHiltTestRule() {
        return this.hasHiltTestRule.get() != null;
    }

    private static enum DelayedComponentState {
        NOT_DELAYED,
        COMPONENT_DELAYED,
        COMPONENT_READY,
        INJECTED;

    }
}

