/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.android.internal.managers;

import android.app.Activity;
import android.app.Application;
import androidx.activity.ComponentActivity;
import dagger.hilt.EntryPoint;
import dagger.hilt.EntryPoints;
import dagger.hilt.InstallIn;
import dagger.hilt.android.components.ActivityRetainedComponent;
import dagger.hilt.android.internal.builders.ActivityComponentBuilder;
import dagger.hilt.android.internal.managers.ActivityRetainedComponentManager;
import dagger.hilt.internal.GeneratedComponentManager;

public class ActivityComponentManager
implements GeneratedComponentManager<Object> {
    private volatile Object component;
    private final Object componentLock = new Object();
    protected final Activity activity;
    private final GeneratedComponentManager<ActivityRetainedComponent> activityRetainedComponentManager;

    public ActivityComponentManager(Activity activity) {
        this.activity = activity;
        this.activityRetainedComponentManager = new ActivityRetainedComponentManager((ComponentActivity)activity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object generatedComponent() {
        if (this.component == null) {
            Object object = this.componentLock;
            synchronized (object) {
                if (this.component == null) {
                    this.component = this.createComponent();
                }
            }
        }
        return this.component;
    }

    protected Object createComponent() {
        if (!(this.activity.getApplication() instanceof GeneratedComponentManager)) {
            throw new IllegalStateException("Hilt Activity must be attached to an @HiltAndroidApp Application. " + (Application.class.equals(this.activity.getApplication().getClass()) ? "Did you forget to specify your Application's class name in your manifest's <application />'s android:name attribute?" : "Found: " + this.activity.getApplication().getClass()));
        }
        return ((ActivityComponentBuilderEntryPoint)EntryPoints.get(this.activityRetainedComponentManager, ActivityComponentBuilderEntryPoint.class)).activityComponentBuilder().activity(this.activity).build();
    }

    @EntryPoint
    @InstallIn(value={ActivityRetainedComponent.class})
    public static interface ActivityComponentBuilderEntryPoint {
        public ActivityComponentBuilder activityComponentBuilder();
    }
}

