/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.android.internal.lifecycle;

import androidx.activity.ComponentActivity;
import androidx.fragment.app.Fragment;
import androidx.lifecycle.ViewModelProvider;
import dagger.Module;
import dagger.hilt.EntryPoint;
import dagger.hilt.EntryPoints;
import dagger.hilt.InstallIn;
import dagger.hilt.android.components.ActivityComponent;
import dagger.hilt.android.components.FragmentComponent;
import dagger.hilt.android.internal.builders.ViewModelComponentBuilder;
import dagger.hilt.android.internal.lifecycle.HiltViewModelFactory;
import dagger.hilt.android.internal.lifecycle.HiltViewModelMap;
import dagger.hilt.internal.Preconditions;
import dagger.multibindings.Multibinds;
import java.util.Map;
import javax.inject.Inject;

public final class DefaultViewModelFactories {
    public static ViewModelProvider.Factory getActivityFactory(ComponentActivity activity, ViewModelProvider.Factory delegateFactory) {
        return ((ActivityEntryPoint)EntryPoints.get((Object)activity, ActivityEntryPoint.class)).getHiltInternalFactoryFactory().fromActivity(activity, delegateFactory);
    }

    public static ViewModelProvider.Factory getFragmentFactory(Fragment fragment, ViewModelProvider.Factory delegateFactory) {
        return ((FragmentEntryPoint)EntryPoints.get((Object)fragment, FragmentEntryPoint.class)).getHiltInternalFactoryFactory().fromFragment(fragment, delegateFactory);
    }

    private DefaultViewModelFactories() {
    }

    @EntryPoint
    @InstallIn(value={ActivityComponent.class})
    public static interface ActivityEntryPoint {
        public InternalFactoryFactory getHiltInternalFactoryFactory();
    }

    public static final class InternalFactoryFactory {
        private final Map<Class<?>, Boolean> keySet;
        private final ViewModelComponentBuilder viewModelComponentBuilder;

        @Inject
        InternalFactoryFactory(@HiltViewModelMap.KeySet Map<Class<?>, Boolean> keySet, ViewModelComponentBuilder viewModelComponentBuilder) {
            this.keySet = keySet;
            this.viewModelComponentBuilder = viewModelComponentBuilder;
        }

        ViewModelProvider.Factory fromActivity(ComponentActivity activity, ViewModelProvider.Factory delegateFactory) {
            return this.getHiltViewModelFactory(delegateFactory);
        }

        ViewModelProvider.Factory fromFragment(Fragment fragment, ViewModelProvider.Factory delegateFactory) {
            return this.getHiltViewModelFactory(delegateFactory);
        }

        private ViewModelProvider.Factory getHiltViewModelFactory(ViewModelProvider.Factory delegate) {
            return new HiltViewModelFactory(this.keySet, (ViewModelProvider.Factory)Preconditions.checkNotNull((Object)delegate), this.viewModelComponentBuilder);
        }
    }

    @EntryPoint
    @InstallIn(value={FragmentComponent.class})
    public static interface FragmentEntryPoint {
        public InternalFactoryFactory getHiltInternalFactoryFactory();
    }

    @Module
    @InstallIn(value={ActivityComponent.class})
    static interface ActivityModule {
        @Multibinds
        @HiltViewModelMap.KeySet
        public Map<Class<?>, Boolean> viewModelKeys();
    }
}

