/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.android.processor.internal.androidentrypoint;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import dagger.hilt.android.processor.internal.androidentrypoint.AndroidEntryPointMetadata;
import dagger.hilt.android.processor.internal.androidentrypoint.Generators;
import dagger.hilt.processor.internal.ClassNames;
import dagger.hilt.processor.internal.Processors;
import java.io.IOException;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;

public final class InjectorEntryPointGenerator {
    private final ProcessingEnvironment env;
    private final AndroidEntryPointMetadata metadata;

    public InjectorEntryPointGenerator(ProcessingEnvironment env, AndroidEntryPointMetadata metadata) {
        this.env = env;
        this.metadata = metadata;
    }

    public void generate() throws IOException {
        ClassName name = this.metadata.injectorClassName();
        TypeSpec.Builder builder = TypeSpec.interfaceBuilder((String)name.simpleName()).addOriginatingElement((Element)this.metadata.element()).addAnnotation(Processors.getOriginatingElementAnnotation(this.metadata.element())).addAnnotation(ClassNames.GENERATED_ENTRY_POINT).addAnnotation(this.metadata.injectorInstallInAnnotation()).addModifiers(new Modifier[]{Modifier.PUBLIC}).addMethod(MethodSpec.methodBuilder((String)this.metadata.injectMethodName()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).addParameter((TypeName)this.metadata.elementClassName(), Processors.upperToLowerCamel(this.metadata.elementClassName().simpleName()), new Modifier[0]).build());
        Processors.addGeneratedAnnotation(builder, this.env, this.getClass());
        Generators.copyLintAnnotations(this.metadata.element(), builder);
        Generators.copySuppressAnnotations(this.metadata.element(), builder);
        JavaFile.builder((String)name.packageName(), (TypeSpec)builder.build()).build().writeTo(this.env.getFiler());
    }
}

