/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.processor.internal.aggregateddeps;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.squareup.javapoet.ClassName;
import dagger.hilt.processor.internal.ClassNames;
import dagger.hilt.processor.internal.ComponentDescriptor;
import dagger.hilt.processor.internal.aggregateddeps.AggregatedDepsMetadata;
import dagger.hilt.processor.internal.aggregateddeps.AutoValue_ComponentDependencies;
import dagger.hilt.processor.internal.aggregateddeps.PkgPrivateMetadata;
import dagger.hilt.processor.internal.earlyentrypoint.AggregatedEarlyEntryPointMetadata;
import dagger.hilt.processor.internal.uninstallmodules.AggregatedUninstallModulesMetadata;
import dagger.internal.codegen.extension.DaggerStreams;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;

@AutoValue
public abstract class ComponentDependencies {
    private static Builder builder() {
        return new AutoValue_ComponentDependencies.Builder();
    }

    public abstract ImmutableSetMultimap<ClassName, TypeElement> modules();

    public abstract ImmutableSetMultimap<ClassName, TypeElement> entryPoints();

    public abstract ImmutableSetMultimap<ClassName, TypeElement> componentEntryPoints();

    public static ComponentDependencies from(ImmutableSet<ComponentDescriptor> descriptors, ImmutableSet<AggregatedDepsMetadata> aggregatedDepsMetadata, ImmutableSet<AggregatedUninstallModulesMetadata> aggregatedUninstallModulesMetadata, ImmutableSet<AggregatedEarlyEntryPointMetadata> aggregatedEarlyEntryPointMetadata, Elements elements) {
        ImmutableSet uninstalledModules = ImmutableSet.builder().addAll((Iterable)aggregatedUninstallModulesMetadata.stream().flatMap(metadata -> metadata.uninstallModuleElements().stream()).map(module -> PkgPrivateMetadata.publicModule(module, elements)).collect(DaggerStreams.toImmutableSet())).addAll((Iterable)aggregatedDepsMetadata.stream().flatMap(metadata -> metadata.replacedDependencies().stream()).collect(DaggerStreams.toImmutableSet())).build();
        Builder componentDependencies = ComponentDependencies.builder();
        ImmutableSet componentNames = (ImmutableSet)descriptors.stream().map(ComponentDescriptor::component).collect(DaggerStreams.toImmutableSet());
        for (AggregatedDepsMetadata metadata2 : aggregatedDepsMetadata) {
            for (TypeElement componentElement : metadata2.componentElements()) {
                ClassName componentName = ClassName.get((TypeElement)componentElement);
                Preconditions.checkState((boolean)componentNames.contains((Object)componentName), (String)"%s is not a valid Component.", (Object)componentName);
                switch (metadata2.dependencyType()) {
                    case MODULE: {
                        if (uninstalledModules.contains((Object)metadata2.dependency())) break;
                        componentDependencies.modulesBuilder().put((Object)componentName, (Object)metadata2.dependency());
                        break;
                    }
                    case ENTRY_POINT: {
                        componentDependencies.entryPointsBuilder().put((Object)componentName, (Object)metadata2.dependency());
                        break;
                    }
                    case COMPONENT_ENTRY_POINT: {
                        componentDependencies.componentEntryPointsBuilder().put((Object)componentName, (Object)metadata2.dependency());
                    }
                }
            }
        }
        componentDependencies.entryPointsBuilder().putAll((Object)ClassNames.SINGLETON_COMPONENT, (Iterable)aggregatedEarlyEntryPointMetadata.stream().map(AggregatedEarlyEntryPointMetadata::earlyEntryPoint).map(entryPoint -> PkgPrivateMetadata.publicEarlyEntryPoint(entryPoint, elements)).collect(DaggerStreams.toImmutableSet()));
        return componentDependencies.build();
    }

    @AutoValue.Builder
    static abstract class Builder {
        Builder() {
        }

        abstract ImmutableSetMultimap.Builder<ClassName, TypeElement> modulesBuilder();

        abstract ImmutableSetMultimap.Builder<ClassName, TypeElement> entryPointsBuilder();

        abstract ImmutableSetMultimap.Builder<ClassName, TypeElement> componentEntryPointsBuilder();

        abstract ComponentDependencies build();
    }
}

