/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.processor.internal;

import com.google.auto.value.AutoValue;
import com.google.common.base.Throwables;
import dagger.hilt.processor.internal.AutoValue_ProcessorErrorHandler_HiltError;
import dagger.hilt.processor.internal.BadInputException;
import dagger.hilt.processor.internal.ErrorTypeException;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XElementKt;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XMessager;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XProcessingEnv;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.tools.Diagnostic;

final class ProcessorErrorHandler {
    private static final String FAILURE_PREFIX = "[Hilt] ";
    private static final String FAILURE_SUFFIX = "\n\u001b[1;31m[Hilt] Processing did not complete. See error above for details.\u001b[0m";
    private final XProcessingEnv processingEnv;
    private final XMessager messager;
    private final List<HiltError> hiltErrors = new ArrayList<HiltError>();

    ProcessorErrorHandler(XProcessingEnv processingEnv) {
        this.processingEnv = processingEnv;
        this.messager = processingEnv.getMessager();
    }

    void recordError(Throwable t) {
        if (t instanceof BadInputException) {
            BadInputException badInput = (BadInputException)t;
            if (badInput.getBadElements().isEmpty()) {
                this.hiltErrors.add(HiltError.of(badInput.getMessage()));
            }
            for (XElement element : badInput.getBadElements()) {
                this.hiltErrors.add(HiltError.of(badInput.getMessage(), element));
            }
        } else if (t instanceof ErrorTypeException) {
            ErrorTypeException badInput = (ErrorTypeException)t;
            this.hiltErrors.add(HiltError.of(badInput.getMessage(), badInput.getBadElement()));
        } else if (t.getMessage() != null) {
            this.hiltErrors.add(HiltError.of(t.getMessage() + ": " + Throwables.getStackTraceAsString((Throwable)t)));
        } else {
            this.hiltErrors.add(HiltError.of(t.getClass() + ": " + Throwables.getStackTraceAsString((Throwable)t)));
        }
    }

    void checkErrors() {
        if (!this.hiltErrors.isEmpty()) {
            this.hiltErrors.forEach(hiltError -> {
                if (hiltError.element().isPresent()) {
                    XElement element = hiltError.element().get();
                    if (XElementKt.isTypeElement((XElement)element)) {
                        element = this.processingEnv.requireTypeElement(XElements.asTypeElement((XElement)element).getQualifiedName());
                    }
                    this.messager.printMessage(Diagnostic.Kind.ERROR, hiltError.message(), element);
                } else {
                    this.messager.printMessage(Diagnostic.Kind.ERROR, hiltError.message());
                }
            });
            this.hiltErrors.clear();
        }
    }

    public boolean isEmpty() {
        return this.hiltErrors.isEmpty();
    }

    @AutoValue
    static abstract class HiltError {
        HiltError() {
        }

        static HiltError of(String message) {
            return HiltError.of(message, Optional.empty());
        }

        static HiltError of(String message, XElement element) {
            return HiltError.of(message, Optional.of(element));
        }

        private static HiltError of(String message, Optional<XElement> element) {
            return new AutoValue_ProcessorErrorHandler_HiltError(ProcessorErrorHandler.FAILURE_PREFIX + message + ProcessorErrorHandler.FAILURE_SUFFIX, element);
        }

        abstract String message();

        abstract Optional<XElement> element();
    }
}

