/*
 * Copyright 2000-2016 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * @author max
 */
package ksp.com.intellij.psi.impl;

import ksp.com.intellij.openapi.project.Project;
import ksp.com.intellij.psi.JavaPsiFacade;
import ksp.com.intellij.psi.PsiClass;
import ksp.com.intellij.psi.search.GlobalSearchScope;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.TestOnly;

public abstract class JavaPsiFacadeEx extends JavaPsiFacade {
  @TestOnly
  public static JavaPsiFacadeEx getInstanceEx(@NotNull Project project) {
    return (JavaPsiFacadeEx)getInstance(project);
  }

  @TestOnly
  public PsiClass findClass(@NotNull String qualifiedName) {
    return findClass(qualifiedName, GlobalSearchScope.allScope(getProject()));
  }
}