/*
 * Copyright 2010-2023 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package ksp.org.jetbrains.kotlin.fir.deserialization

import ksp.org.jetbrains.kotlin.fir.FirSession
import ksp.org.jetbrains.kotlin.fir.FirSessionComponent
import ksp.org.jetbrains.kotlin.fir.declarations.builder.FirRegularClassBuilder
import ksp.org.jetbrains.kotlin.metadata.ProtoBuf
import ksp.org.jetbrains.kotlin.metadata.deserialization.NameResolver
import ksp.org.jetbrains.kotlin.name.ClassId
import ksp.org.jetbrains.kotlin.serialization.SerializerExtensionProtocol
import ksp.org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedContainerSource

abstract class FirDeserializationExtension(val session: FirSession) : FirSessionComponent {
    open fun createConstDeserializer(
        containerSource: DeserializedContainerSource?,
        session: FirSession,
        serializerExtensionProtocol: SerializerExtensionProtocol,
    ): FirConstDeserializer? = null

    open fun FirRegularClassBuilder.configureDeserializedClass(classId: ClassId) {}

    open fun loadModuleName(classProto: ProtoBuf.Class, nameResolver: NameResolver): String? = null

    open fun loadHasBackingFieldFlag(propertyProto: ProtoBuf.Property): Boolean? = null

    open fun isMaybeMultiFieldValueClass(containerSource: DeserializedContainerSource?): Boolean = false
}
