/*
 * Copyright 2010-2024 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

// This file was generated automatically. See compiler/fir/tree/tree-generator/Readme.md.
// DO NOT MODIFY IT MANUALLY.

@file:Suppress("DuplicatedCode", "unused")

package ksp.org.jetbrains.kotlin.fir.references.builder

import kotlin.contracts.*
import ksp.org.jetbrains.kotlin.KtSourceElement
import ksp.org.jetbrains.kotlin.fir.builder.FirBuilderDsl
import ksp.org.jetbrains.kotlin.fir.references.FirResolvedNamedReference
import ksp.org.jetbrains.kotlin.fir.references.impl.FirResolvedNamedReferenceImpl
import ksp.org.jetbrains.kotlin.fir.resolve.FirResolvedSymbolOrigin
import ksp.org.jetbrains.kotlin.fir.symbols.FirBasedSymbol
import ksp.org.jetbrains.kotlin.name.Name

@FirBuilderDsl
class FirResolvedNamedReferenceBuilder {
    var source: KtSourceElement? = null
    lateinit var name: Name
    lateinit var resolvedSymbol: FirBasedSymbol<*>
    var resolvedSymbolOrigin: FirResolvedSymbolOrigin? = null

    fun build(): FirResolvedNamedReference {
        return FirResolvedNamedReferenceImpl(
            source,
            name,
            resolvedSymbol,
            resolvedSymbolOrigin,
        )
    }

}

@OptIn(ExperimentalContracts::class)
inline fun buildResolvedNamedReference(init: FirResolvedNamedReferenceBuilder.() -> Unit): FirResolvedNamedReference {
    contract {
        callsInPlace(init, InvocationKind.EXACTLY_ONCE)
    }
    return FirResolvedNamedReferenceBuilder().apply(init).build()
}
