/*
 * Copyright 2010-2025 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package ksp.org.jetbrains.kotlin.psi.stubs.impl

import ksp.com.intellij.psi.stubs.IStubElementType
import ksp.com.intellij.psi.stubs.StubElement
import ksp.org.jetbrains.kotlin.psi.KtElementImplStub
import ksp.org.jetbrains.kotlin.psi.KtImplementationDetail
import ksp.org.jetbrains.kotlin.psi.stubs.KotlinPlaceHolderWithTextStub

@OptIn(KtImplementationDetail::class)
class KotlinPlaceHolderWithTextStubImpl<T : KtElementImplStub<*>>(
    parent: StubElement<*>?,
    elementType: IStubElementType<*, *>,
    override val text: String,
) : KotlinStubBaseImpl<T>(parent, elementType), KotlinPlaceHolderWithTextStub<T> {
    @KtImplementationDetail
    override fun copyInto(newParent: StubElement<*>?): KotlinPlaceHolderWithTextStubImpl<T> = KotlinPlaceHolderWithTextStubImpl(
        parent = newParent,
        elementType = stubType,
        text = text,
    )
}
