/*
 * Copyright 2010-2025 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package ksp.org.jetbrains.kotlin.fir.resolve.calls.js

import ksp.org.jetbrains.kotlin.fir.NoMutableState
import ksp.org.jetbrains.kotlin.fir.resolve.BodyResolveComponents
import ksp.org.jetbrains.kotlin.fir.resolve.calls.overloads.ConeCallConflictResolverFactory
import ksp.org.jetbrains.kotlin.fir.resolve.calls.overloads.ConeCompositeConflictResolver
import ksp.org.jetbrains.kotlin.fir.resolve.calls.overloads.ConeEquivalentCallConflictResolver
import ksp.org.jetbrains.kotlin.fir.resolve.calls.overloads.ConeIntegerOperatorConflictResolver
import ksp.org.jetbrains.kotlin.fir.resolve.calls.overloads.ConeOverloadConflictResolver
import ksp.org.jetbrains.kotlin.fir.resolve.inference.InferenceComponents
import ksp.org.jetbrains.kotlin.fir.types.typeContext
import ksp.org.jetbrains.kotlin.js.resolve.JsTypeSpecificityComparatorWithoutDelegate
import ksp.org.jetbrains.kotlin.resolve.calls.results.TypeSpecificityComparator

@NoMutableState
object JsCallConflictResolverFactory : ConeCallConflictResolverFactory() {
    override fun create(
        typeSpecificityComparator: TypeSpecificityComparator,
        components: InferenceComponents,
        transformerComponents: BodyResolveComponents
    ): ConeCompositeConflictResolver {
        val specificityComparator = JsTypeSpecificityComparatorWithoutDelegate(components.session.typeContext)
        // NB: Adding new resolvers is strongly discouraged because the results are order-dependent.
        return ConeCompositeConflictResolver(
            ConeEquivalentCallConflictResolver(components.session),
            ConeIntegerOperatorConflictResolver,
            ConeOverloadConflictResolver(specificityComparator, components, transformerComponents),
        )
    }
}
