// Copyright 2000-2023 JetBrains s.r.o. and contributors. Use of this source code is governed by the Apache 2.0 license.
package ksp.com.intellij.model.psi;

import ksp.com.intellij.model.Symbol;
import ksp.com.intellij.openapi.util.TextRange;
import ksp.com.intellij.psi.PsiElement;
import ksp.org.jetbrains.annotations.NotNull;

import java.util.Collection;

final class ImmediatePsiSymbolReference implements PsiSymbolReference {

  private final @NotNull PsiElement myElement;
  private final @NotNull Collection<? extends @NotNull Symbol> myTargets;

  ImmediatePsiSymbolReference(@NotNull PsiElement element, @NotNull Collection<? extends @NotNull Symbol> targets) {
    myElement = element;
    myTargets = targets;
  }

  @Override
  public @NotNull PsiElement getElement() {
    return myElement;
  }

  @Override
  public @NotNull TextRange getRangeInElement() {
    return TextRange.from(0, myElement.getTextLength());
  }

  @Override
  public @NotNull Collection<? extends Symbol> resolveReference() {
    return myTargets;
  }
}
