/*
 * Copyright 2000-2017 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package ksp.com.intellij.psi.impl.source.tree;

import ksp.com.intellij.lang.ASTNode;
import ksp.com.intellij.psi.PsiElement;
import ksp.com.intellij.psi.impl.source.PsiJShellHolderMethodImpl;
import ksp.com.intellij.psi.impl.source.PsiJShellImportHolderImpl;
import ksp.com.intellij.psi.impl.source.PsiJShellRootClassImpl;
import ksp.com.intellij.psi.tree.IElementType;

import java.util.concurrent.atomic.AtomicInteger;

/**
 * @author Eugene Zhuravlev
 */
public interface JShellElementType {
  IElementType ROOT_CLASS = new IJShellElementType("JSHELL_ROOT_CLASS") {
    private final AtomicInteger ourClassCounter = new AtomicInteger();
    @Override
    public PsiElement createPsi(ASTNode node) {
      return new PsiJShellRootClassImpl(node, ourClassCounter.getAndIncrement());
    }
  };

  IElementType STATEMENTS_HOLDER = new IJShellElementType("JSHELL_STATEMENTS_HOLDER") {
    private final AtomicInteger ourMethodCounter = new AtomicInteger();
    @Override
    public PsiElement createPsi(ASTNode node) {
      return new PsiJShellHolderMethodImpl(node, ourMethodCounter.getAndIncrement());
    }
  };

  IElementType IMPORT_HOLDER = new IJShellElementType("JSHELL_IMPORT_HOLDER") {
    @Override
    public PsiElement createPsi(ASTNode node) {
      return new PsiJShellImportHolderImpl(node);
    }
  };
}
