// Copyright 2000-2022 JetBrains s.r.o. and contributors. Use of this source code is governed by the Apache 2.0 license.
package ksp.com.intellij.psi.javadoc;

import ksp.com.intellij.openapi.project.Project;
import ksp.com.intellij.psi.PsiElement;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;

public interface JavadocManager {

  static JavadocManager getInstance(@NotNull Project project) {
    return project.getService(JavadocManager.class);
  }

  JavadocTagInfo @NotNull [] getTagInfos(PsiElement context);

  @Nullable
  JavadocTagInfo getTagInfo(String name);
}