/*
 * Copyright 2010-2025 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package ksp.org.jetbrains.kotlin.analysis.api.resolution

import ksp.org.jetbrains.kotlin.analysis.api.KaImplementationDetail
import ksp.org.jetbrains.kotlin.analysis.api.KaSession
import ksp.org.jetbrains.kotlin.analysis.api.symbols.KaSymbol
import ksp.org.jetbrains.kotlin.idea.references.KtReference

@KaImplementationDetail
@SubclassOptInRequired(KaImplementationDetail::class)
public interface KaSymbolBasedReference : KtReference {
    public fun KaSession.resolveToSymbols(): Collection<KaSymbol>
}
