/*
 * Copyright 2010-2025 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package ksp.org.jetbrains.kotlin.analysis.api.signatures

import ksp.org.jetbrains.kotlin.analysis.api.KaExperimentalApi
import ksp.org.jetbrains.kotlin.analysis.api.KaImplementationDetail
import ksp.org.jetbrains.kotlin.analysis.api.symbols.KaFunctionSymbol
import ksp.org.jetbrains.kotlin.analysis.api.symbols.KaValueParameterSymbol
import ksp.org.jetbrains.kotlin.analysis.api.types.KaSubstitutor

/**
 * A [callable signature][KaCallableSignature] of a [function symbol][KaFunctionSymbol].
 */
@SubclassOptInRequired(KaImplementationDetail::class)
public interface KaFunctionSignature<out S : KaFunctionSymbol> : KaCallableSignature<S> {
    /**
     * The use-site-substituted [value parameters][KaFunctionSymbol.valueParameters].
     */
    public val valueParameters: List<KaVariableSignature<KaValueParameterSymbol>>

    @KaExperimentalApi
    abstract override fun substitute(substitutor: KaSubstitutor): KaFunctionSignature<S>
}
