/*
 * Copyright 2010-2022 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package ksp.org.jetbrains.kotlin.fir.analysis.native.checkers

import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory0
import ksp.org.jetbrains.kotlin.diagnostics.reportOn
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext
import ksp.org.jetbrains.kotlin.fir.declarations.FirDeclaration
import ksp.org.jetbrains.kotlin.fir.declarations.getAnnotationByClassId
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol
import ksp.org.jetbrains.kotlin.name.ClassId
import ksp.org.jetbrains.kotlin.name.NativeForwardDeclarationKind

context(context: CheckerContext)
fun DiagnosticReporter.reportIfHasAnnotation(
    declaration: FirDeclaration,
    annotationClassId: ClassId,
    error: KtDiagnosticFactory0
) {
    val annotation = declaration.getAnnotationByClassId(annotationClassId, context.session)
    if (annotation != null) {
        reportOn(annotation.source, error)
    }
}

fun FirRegularClassSymbol.forwardDeclarationKindOrNull(): NativeForwardDeclarationKind? =
    NativeForwardDeclarationKind.packageFqNameToKind[classId.packageFqName]