/*
 * Copyright 2010-2024 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package ksp.org.jetbrains.kotlin.fir.renderer

import ksp.org.jetbrains.kotlin.fir.contracts.description.ConeContractRenderer

internal interface FirRendererComponents {
    val visitor: FirRenderer.Visitor
    val printer: FirPrinter
    val declarationRenderer: FirDeclarationRenderer?
    val annotationRenderer: FirAnnotationRenderer?
    val bodyRenderer: FirBodyRenderer?
    val callArgumentsRenderer: FirCallArgumentsRenderer?
    val contextArgumentRenderer: FirContextArgumentRenderer?
    val classMemberRenderer: FirClassMemberRenderer?
    val contractRenderer: ConeContractRenderer?
    val idRenderer: ConeIdRenderer
    val modifierRenderer: FirModifierRenderer?
    val packageDirectiveRenderer: FirPackageDirectiveRenderer?
    val propertyAccessorRenderer: FirPropertyAccessorRenderer?
    val resolvePhaseRenderer: FirResolvePhaseRenderer?
    val typeRenderer: ConeTypeRenderer
    val referencedSymbolRenderer: FirSymbolRenderer
    val callableSignatureRenderer: FirCallableSignatureRenderer?
    val errorExpressionRenderer: FirErrorExpressionRenderer?
    val resolvedNamedReferenceRenderer: FirResolvedNamedReferenceRenderer
    val resolvedQualifierRenderer: FirResolvedQualifierRenderer
    val getClassCallRenderer: FirGetClassCallRenderer
    val supertypeRenderer: FirSupertypeRenderer?
}