/*
 * Copyright 2010-2025 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package ksp.org.jetbrains.kotlin.psi.stubs.impl

import ksp.com.intellij.psi.PsiElement
import ksp.com.intellij.psi.stubs.StubElement
import ksp.com.intellij.util.io.StringRef
import ksp.org.jetbrains.kotlin.name.FqName
import ksp.org.jetbrains.kotlin.psi.KtSecondaryConstructor
import ksp.org.jetbrains.kotlin.psi.stubs.KotlinConstructorStub
import ksp.org.jetbrains.kotlin.psi.stubs.elements.KtStubElementTypes

class KotlinSecondaryConstructorStubImpl(
    parent: StubElement<out PsiElement>?,
    private val containingClassName: StringRef?,
    override val hasBody: Boolean,
    override val isDelegatedCallToThis: Boolean,
    override val isExplicitDelegationCall: Boolean,
    override val mayHaveContract: Boolean,
) : KotlinStubBaseImpl<KtSecondaryConstructor>(parent, KtStubElementTypes.SECONDARY_CONSTRUCTOR),
    KotlinConstructorStub<KtSecondaryConstructor> {
    override val fqName: FqName? get() = null
    override fun getName(): String? = StringRef.toString(containingClassName)
    override val isTopLevel: Boolean get() = false
    override val isExtension: Boolean get() = false

    // It cannot have expression body
    override val hasNoExpressionBody: Boolean
        get() = true
}
