// Copyright 2000-2020 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package ksp.com.intellij.openapi.util;

import ksp.com.intellij.openapi.extensions.RequiredElement;
import ksp.com.intellij.serviceContainer.BaseKeyedLazyInstance;
import ksp.com.intellij.util.KeyedLazyInstance;
import ksp.com.intellij.util.xmlb.annotations.Attribute;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;

public final class ClassExtensionPoint<T> extends BaseKeyedLazyInstance<T> implements KeyedLazyInstance<T> {
  // these must be public for scrambling compatibility
  @Attribute("forClass")
  @RequiredElement
  public String psiElementClass;

  @Attribute("implementationClass")
  @RequiredElement
  public String implementationClass;

  @Override
  protected @Nullable String getImplementationClassName() {
    return implementationClass;
  }

  @Override
  public @NotNull String getKey() {
    return psiElementClass;
  }
}