/*
 * Copyright 2010-2024 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package ksp.org.jetbrains.kotlin.analysis.api.fir

import ksp.org.jetbrains.kotlin.analysis.api.impl.base.imports.KaBaseDefaultImportsProvider
import ksp.org.jetbrains.kotlin.analysis.low.level.api.fir.util.getWasmTarget
import ksp.org.jetbrains.kotlin.analyzer.common.CommonPlatformAnalyzerServices
import ksp.org.jetbrains.kotlin.fir.resolve.FirJvmDefaultImportProvider
import ksp.org.jetbrains.kotlin.js.resolve.JsPlatformAnalyzerServices
import ksp.org.jetbrains.kotlin.platform.JsPlatform
import ksp.org.jetbrains.kotlin.platform.TargetPlatform
import ksp.org.jetbrains.kotlin.platform.WasmPlatform
import ksp.org.jetbrains.kotlin.platform.jvm.JvmPlatform
import ksp.org.jetbrains.kotlin.platform.konan.NativePlatform
import ksp.org.jetbrains.kotlin.platform.wasm.WasmTarget
import ksp.org.jetbrains.kotlin.resolve.DefaultImportProvider
import ksp.org.jetbrains.kotlin.resolve.konan.platform.NativePlatformAnalyzerServices
import ksp.org.jetbrains.kotlin.wasm.resolve.WasmPlatformAnalyzerServices
import ksp.org.jetbrains.kotlin.wasm.resolve.WasmWasiPlatformAnalyzerServices

// K1 implementation is in IDE: `org.jetbrains.kotlin.base.fe10.analysis.KaFe10DefaultImportsProvider`
internal class KaFirDefaultImportsProvider : KaBaseDefaultImportsProvider() {
    override fun getCompilerDefaultImportProvider(targetPlatform: TargetPlatform): DefaultImportProvider = when {
        targetPlatform.all { it is JvmPlatform } -> FirJvmDefaultImportProvider
        targetPlatform.all { it is JsPlatform } -> JsPlatformAnalyzerServices
        targetPlatform.all { it is NativePlatform } -> NativePlatformAnalyzerServices
        targetPlatform.all { it is WasmPlatform } -> when (targetPlatform.getWasmTarget()) {
            WasmTarget.JS -> WasmPlatformAnalyzerServices
            WasmTarget.WASI -> WasmWasiPlatformAnalyzerServices
        }
        else -> CommonPlatformAnalyzerServices
    }
}