/*
 * Copyright 2010-2023 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package ksp.org.jetbrains.kotlin.analysis.api.fir.utils

import ksp.org.jetbrains.kotlin.analysis.api.KaSession
import ksp.org.jetbrains.kotlin.analysis.api.fir.symbols.KaFirSymbol
import ksp.org.jetbrains.kotlin.analysis.api.getModule
import ksp.org.jetbrains.kotlin.analysis.api.symbols.DebugSymbolRenderer
import ksp.org.jetbrains.kotlin.analysis.api.symbols.KaSymbol
import ksp.org.jetbrains.kotlin.fir.utils.exceptions.withFirEntry
import ksp.org.jetbrains.kotlin.utils.exceptions.ExceptionAttachmentBuilder
import ksp.org.jetbrains.kotlin.analysis.api.utils.errors.withPsiEntry

internal fun ExceptionAttachmentBuilder.withSymbolAttachment(name: String, analysisSession: KaSession, symbol: KaSymbol) {
    withEntry(name, symbol) { DebugSymbolRenderer(renderExtra = true).render(analysisSession, it) }

    val psi = symbol.psi
    val psiModule = psi?.let(analysisSession::getModule)
    withPsiEntry("${name}Psi", psi, psiModule)

    if (symbol is KaFirSymbol<*>) {
        val symbolFir = symbol.firSymbol.fir
        withFirEntry("${name}Fir", symbolFir)
    }
}