/*
 * Copyright 2010-2022 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package ksp.org.jetbrains.kotlin.analysis.api.impl.base.components

import ksp.org.jetbrains.kotlin.analysis.api.KaImplementationDetail
import ksp.org.jetbrains.kotlin.analysis.api.KaSession
import ksp.org.jetbrains.kotlin.analysis.api.components.KaRenderer
import ksp.org.jetbrains.kotlin.analysis.api.lifetime.withValidityAssertion
import ksp.org.jetbrains.kotlin.analysis.api.renderer.declarations.KaDeclarationRenderer
import ksp.org.jetbrains.kotlin.analysis.api.renderer.types.KaTypeRenderer
import ksp.org.jetbrains.kotlin.analysis.api.symbols.KaDeclarationSymbol
import ksp.org.jetbrains.kotlin.analysis.api.types.KaType
import ksp.org.jetbrains.kotlin.analysis.utils.printer.prettyPrint
import ksp.org.jetbrains.kotlin.types.Variance

@KaImplementationDetail
class KaRendererImpl(
    override val analysisSessionProvider: () -> KaSession
) : KaRenderer, KaBaseSessionComponent<KaSession>() {
    override fun KaDeclarationSymbol.render(renderer: KaDeclarationRenderer): String = withValidityAssertion {
        return with(analysisSession) {
            prettyPrint { renderer.renderDeclaration(useSiteSession, this@render, this) }
        }
    }

    override fun KaType.render(renderer: KaTypeRenderer, position: Variance): String = withValidityAssertion {
        return with(analysisSession) {
            val approximatedType = renderer.typeApproximator.approximateType(useSiteSession, this@render, position)
            prettyPrint { renderer.renderType(useSiteSession, approximatedType, this) }
        }
    }
}