/*
 * Copyright 2010-2025 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package ksp.org.jetbrains.kotlin.backend.common.linkage.partial

import ksp.org.jetbrains.kotlin.ir.declarations.IrDeclarationOriginImpl

object PartiallyLinkedDeclarationOrigin {
    /** The unresolved (missing) declaration */
    val MISSING_DECLARATION by IrDeclarationOriginImpl

    /** The abstract callable member that needs to be implemented in non-abstract class */
    val UNIMPLEMENTED_ABSTRACT_CALLABLE_MEMBER by IrDeclarationOriginImpl

    /** The callable member is not implemented and inherit several implementations from interfaces, but no implementation from class */
    val AMBIGUOUS_NON_OVERRIDDEN_CALLABLE_MEMBER by IrDeclarationOriginImpl

    /** Auxiliary declaration generated by [PartiallyLinkedIrTreePatcher] */
    val AUXILIARY_GENERATED_DECLARATION by IrDeclarationOriginImpl

    val entries: Set<IrDeclarationOriginImpl> = setOf(
        MISSING_DECLARATION,
        UNIMPLEMENTED_ABSTRACT_CALLABLE_MEMBER,
        AMBIGUOUS_NON_OVERRIDDEN_CALLABLE_MEMBER,
        AUXILIARY_GENERATED_DECLARATION,
    )
}