/*
 * Copyright 2010-2023 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package ksp.org.jetbrains.kotlin.fir.analysis.collectors.components

import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter
import ksp.org.jetbrains.kotlin.diagnostics.impl.BaseDiagnosticsCollector
import ksp.org.jetbrains.kotlin.fir.FirSession
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.LanguageVersionSettingsCheckers
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext
import ksp.org.jetbrains.kotlin.fir.analysis.checkersComponent

class LanguageVersionSettingsDiagnosticComponent(
    session: FirSession,
    reporter: DiagnosticReporter,
    private val checkers: LanguageVersionSettingsCheckers = session.checkersComponent.languageVersionSettingsCheckers,
) : AbstractDiagnosticCollectorComponent(session, reporter) {
    override fun checkSettings(data: CheckerContext) {
        val rawReporter = (reporter as? BaseDiagnosticsCollector)?.rawReporter ?: return
        for (checker in checkers.languageVersionSettingsCheckers) {
            with(data) {
                checker.check(rawReporter)
            }
        }
    }
}
