/*
 * Copyright 2010-2024 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package ksp.org.jetbrains.kotlin.fir.analysis.jvm.checkers.expression

import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.expression.AbstractFirUnnecessarySafeCallChecker
import ksp.org.jetbrains.kotlin.fir.expressions.FirSafeCallExpression
import ksp.org.jetbrains.kotlin.fir.java.enhancement.EnhancedForWarningConeSubstitutor
import ksp.org.jetbrains.kotlin.fir.resolve.fullyExpandedType
import ksp.org.jetbrains.kotlin.fir.types.resolvedType
import ksp.org.jetbrains.kotlin.fir.types.typeContext

object FirJavaUnnecessarySafeCallChecker : AbstractFirUnnecessarySafeCallChecker() {
    context(context: CheckerContext, reporter: DiagnosticReporter)
    override fun check(expression: FirSafeCallExpression) {
        val receiverType = EnhancedForWarningConeSubstitutor(context.session.typeContext)
            .substituteOrNull(expression.receiver.resolvedType)
            ?.fullyExpandedType() ?: return

        checkSafeCallReceiverType(receiverType, expression.source)
    }
}

