/*
 * Copyright 2010-2023 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package ksp.org.jetbrains.kotlin.fir.types.impl

import ksp.org.jetbrains.kotlin.KtSourceElement
import ksp.org.jetbrains.kotlin.fir.FirElement
import ksp.org.jetbrains.kotlin.fir.expressions.FirAnnotation
import ksp.org.jetbrains.kotlin.fir.types.FirImplicitTypeRef
import ksp.org.jetbrains.kotlin.fir.visitors.FirTransformer
import ksp.org.jetbrains.kotlin.fir.visitors.FirVisitor

object FirImplicitTypeRefImplWithoutSource : FirImplicitTypeRef() {
    override val customRenderer: Boolean
        get() = false

    override val source: KtSourceElement? get() = null
    override val annotations: List<FirAnnotation> get() = emptyList()

    override fun replaceAnnotations(newAnnotations: List<FirAnnotation>) {
    }

    override fun <D> transformAnnotations(transformer: FirTransformer<D>, data: D): FirImplicitTypeRef {
        return this
    }

    override fun <R, D> acceptChildren(visitor: FirVisitor<R, D>, data: D) {
    }

    override fun <D> transformChildren(transformer: FirTransformer<D>, data: D): FirElement {
        return this
    }
}
