package ksp.org.jetbrains.kotlin.ir.backend.jvm

import ksp.org.jetbrains.kotlin.backend.common.LoadedKlibs
import ksp.org.jetbrains.kotlin.backend.common.reportLoadingProblemsIfAny
import ksp.org.jetbrains.kotlin.config.CompilerConfiguration
import ksp.org.jetbrains.kotlin.config.klibPaths
import ksp.org.jetbrains.kotlin.config.zipFileSystemAccessor
import ksp.org.jetbrains.kotlin.library.loader.KlibLoader

/**
 * This is the entry point to load Kotlin/JVM experimental KLIBs.
 *
 * @param configuration The current compiler configuration.
 */
fun loadJvmKlibs(configuration: CompilerConfiguration): LoadedKlibs {
    val result = KlibLoader {
        libraryPaths(configuration.klibPaths)
        configuration.zipFileSystemAccessor?.let { zipFileSystemAccessor(it)}
    }.load()
    result.reportLoadingProblemsIfAny(configuration, allAsErrors = true)
    return LoadedKlibs(all = result.librariesStdlibFirst)
}
