/*
 * Copyright 2010-2019 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package ksp.org.jetbrains.kotlin.ir.builders.declarations

import ksp.org.jetbrains.kotlin.descriptors.DescriptorVisibilities
import ksp.org.jetbrains.kotlin.descriptors.DescriptorVisibility
import ksp.org.jetbrains.kotlin.descriptors.annotations.Annotations
import ksp.org.jetbrains.kotlin.ir.builders.IrElementBuilder
import ksp.org.jetbrains.kotlin.ir.declarations.IrDeclaration
import ksp.org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin
import ksp.org.jetbrains.kotlin.ir.declarations.IrDeclarationWithVisibility
import ksp.org.jetbrains.kotlin.name.Name

abstract class IrDeclarationBuilder : IrElementBuilder() {
    var origin: IrDeclarationOrigin = IrDeclarationOrigin.DEFINED
    var visibility: DescriptorVisibility = DescriptorVisibilities.PUBLIC

    lateinit var name: Name

    fun updateFrom(from: IrDeclaration) {
        super.updateFrom(from)

        origin = from.origin
        visibility = if (from is IrDeclarationWithVisibility) from.visibility else DescriptorVisibilities.PUBLIC
    }
}
