/*
 * Copyright 2010-2025 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package ksp.org.jetbrains.kotlin.psi.stubs.impl

import ksp.com.intellij.psi.stubs.StubElement
import ksp.com.intellij.util.io.StringRef
import ksp.org.jetbrains.kotlin.name.FqName
import ksp.org.jetbrains.kotlin.psi.KtImportDirective
import ksp.org.jetbrains.kotlin.psi.stubs.KotlinImportDirectiveStub
import ksp.org.jetbrains.kotlin.psi.stubs.elements.KtStubElementTypes

class KotlinImportDirectiveStubImpl(
    parent: StubElement<*>,
    override val isAllUnder: Boolean,
    private val importedFqNameRef: StringRef?,
    override val isValid: Boolean,
) : KotlinStubBaseImpl<KtImportDirective>(parent, KtStubElementTypes.IMPORT_DIRECTIVE), KotlinImportDirectiveStub {
    override val importedFqName: FqName?
        get() = importedFqNameRef?.string?.let(::FqName)
}
