// Copyright 2000-2023 JetBrains s.r.o. and contributors. Use of this source code is governed by the Apache 2.0 license.

// Generated by JFlex 1.9.1 http://jflex.de/  (tweaked for IntelliJ platform)
// source: _JavaLexer.flex

package ksp.com.intellij.lang.java.lexer;

import ksp.com.intellij.pom.java.LanguageLevel;
import ksp.com.intellij.psi.JavaTokenType;
import ksp.com.intellij.psi.tree.IElementType;
import ksp.com.intellij.lexer.FlexLexer;

@SuppressWarnings("ALL")

class _JavaLexer implements FlexLexer {

  /** This character denotes the end of file */
  public static final int YYEOF = -1;

  /** initial size of the lookahead buffer */
  private static final int ZZ_BUFFERSIZE = 16384;

  /** lexical states */
  public static final int YYINITIAL = 0;

  /**
   * ZZ_LEXSTATE[l] is the state in the DFA for the lexical state l
   * ZZ_LEXSTATE[l+1] is the state in the DFA for the lexical state l
   *                  at the beginning of a line
   * l is of the form l = 2*k, k a non negative integer
   */
  private static final int ZZ_LEXSTATE[] = {
     0, 0
  };

  /**
   * Top-level table for translating characters to character classes
   */
  private static final int [] ZZ_CMAP_TOP = zzUnpackcmap_top();

  private static final String ZZ_CMAP_TOP_PACKED_0 =
    "\1\0\1\u0100\1\u0200\1\u0300\1\u0400\1\u0500\1\u0600\1\u0700"+
    "\1\u0800\1\u0900\1\u0a00\1\u0b00\1\u0c00\1\u0d00\1\u0e00\1\u0f00"+
    "\1\u1000\1\u0100\1\u1100\1\u1200\1\u1300\1\u0100\1\u1400\1\u1500"+
    "\1\u1600\1\u1700\1\u1800\1\u1900\1\u1a00\1\u1b00\1\u0100\1\u1c00"+
    "\1\u1d00\1\u1e00\12\u1f00\1\u2000\1\u2100\1\u2200\1\u1f00\1\u2300"+
    "\1\u2400\2\u1f00\31\u0100\1\u2500\121\u0100\1\u2600\4\u0100\1\u2700"+
    "\1\u0100\1\u2800\1\u2900\1\u2a00\1\u2b00\1\u2c00\1\u2d00\53\u0100"+
    "\1\u2e00\41\u1f00\1\u0100\1\u2f00\1\u3000\1\u0100\1\u3100\1\u3200"+
    "\1\u3300\1\u3400\1\u3500\1\u3600\1\u3700\1\u3800\1\u3900\1\u0100"+
    "\1\u3a00\1\u3b00\1\u3c00\1\u3d00\1\u3e00\1\u3f00\1\u4000\1\u4100"+
    "\1\u4200\1\u4300\1\u4400\1\u4500\1\u4600\1\u4700\1\u4800\1\u4900"+
    "\1\u4a00\1\u4b00\1\u4c00\1\u4d00\1\u1f00\1\u4e00\1\u4f00\1\u5000"+
    "\1\u5100\3\u0100\1\u5200\1\u5300\1\u5400\12\u1f00\4\u0100\1\u5500"+
    "\17\u1f00\2\u0100\1\u5600\41\u1f00\2\u0100\1\u5700\1\u5800\2\u1f00"+
    "\1\u5900\1\u5a00\27\u0100\1\u5b00\4\u0100\1\u5c00\1\u5d00\42\u1f00"+
    "\1\u0100\1\u5e00\1\u5f00\11\u1f00\1\u6000\24\u1f00\1\u6100\1\u6200"+
    "\1\u1f00\1\u6300\1\u6400\1\u6500\1\u6600\2\u1f00\1\u6700\5\u1f00"+
    "\1\u6800\1\u6900\1\u6a00\5\u1f00\1\u6b00\1\u6c00\2\u1f00\1\u6d00"+
    "\1\u1f00\1\u6e00\14\u1f00\1\u6f00\4\u1f00\246\u0100\1\u7000\20\u0100"+
    "\1\u7100\1\u7200\25\u0100\1\u7300\34\u0100\1\u7400\14\u1f00\2\u0100"+
    "\1\u7500\5\u1f00\23\u0100\1\u7600\u0aec\u1f00\1\u7700\1\u7800\u02fe\u1f00";

  private static int [] zzUnpackcmap_top() {
    int [] result = new int[4352];
    int offset = 0;
    offset = zzUnpackcmap_top(ZZ_CMAP_TOP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackcmap_top(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /**
   * Second-level tables for translating characters to character classes
   */
  private static final int [] ZZ_CMAP_BLOCKS = zzUnpackcmap_blocks();

  private static final String ZZ_CMAP_BLOCKS_PACKED_0 =
    "\11\0\5\1\16\0\5\1\1\2\2\1\1\3\1\4"+
    "\1\5\1\1\1\6\1\7\1\10\1\11\1\12\1\13"+
    "\1\14\1\15\1\16\11\17\1\20\1\21\1\22\1\23"+
    "\1\24\1\25\1\26\1\27\1\30\1\27\1\31\1\32"+
    "\1\33\5\3\1\34\3\3\1\35\7\3\1\36\2\3"+
    "\1\37\1\1\1\40\1\41\1\42\1\1\1\43\1\44"+
    "\1\45\1\46\1\47\1\50\1\51\1\52\1\53\1\3"+
    "\1\54\1\55\1\56\1\57\1\60\1\61\1\3\1\62"+
    "\1\63\1\64\1\65\1\66\1\67\1\70\1\71\1\72"+
    "\1\73\1\74\1\75\1\76\41\0\2\1\4\3\4\1"+
    "\1\3\2\1\1\0\7\1\1\3\4\1\1\3\5\1"+
    "\27\3\1\1\37\3\1\1\u01ca\3\4\1\14\3\16\1"+
    "\5\3\7\1\1\3\1\1\1\3\21\1\160\0\5\3"+
    "\1\1\2\3\2\1\4\3\1\1\1\3\6\1\1\3"+
    "\1\1\3\3\1\1\1\3\1\1\24\3\1\1\123\3"+
    "\1\1\213\3\1\1\5\0\2\1\246\3\1\1\46\3"+
    "\2\1\1\3\6\1\51\3\6\1\1\3\1\1\55\0"+
    "\1\1\1\0\1\1\2\0\1\1\2\0\1\1\1\0"+
    "\10\1\33\3\4\1\4\3\15\1\6\0\5\1\1\3"+
    "\4\1\13\0\1\1\1\0\3\1\53\3\37\0\4\1"+
    "\2\3\1\0\143\3\1\1\1\3\10\0\1\1\6\0"+
    "\2\3\2\0\1\1\4\0\2\3\12\0\3\3\2\1"+
    "\1\3\17\1\1\0\1\3\1\0\36\3\33\0\2\1"+
    "\131\3\13\0\1\3\16\1\12\0\41\3\11\0\2\3"+
    "\4\1\1\3\2\1\1\0\30\3\4\0\1\3\11\0"+
    "\1\3\3\0\1\3\5\0\22\1\31\3\3\0\4\1"+
    "\13\3\65\1\25\3\1\1\22\3\13\1\61\0\66\3"+
    "\3\0\1\3\22\0\1\3\7\0\12\3\2\0\2\1"+
    "\12\0\1\1\20\3\3\0\1\1\10\3\2\1\2\3"+
    "\2\1\26\3\1\1\7\3\1\1\1\3\3\1\4\3"+
    "\2\1\1\0\1\3\7\0\2\1\2\0\2\1\3\0"+
    "\1\3\10\1\1\0\4\1\2\3\1\1\3\3\2\0"+
    "\2\1\12\0\4\3\7\1\2\3\1\1\1\0\2\1"+
    "\3\0\1\1\6\3\4\1\2\3\2\1\26\3\1\1"+
    "\7\3\1\1\2\3\1\1\2\3\1\1\2\3\2\1"+
    "\1\0\1\1\5\0\4\1\2\0\2\1\3\0\3\1"+
    "\1\0\7\1\4\3\1\1\1\3\7\1\14\0\3\3"+
    "\1\0\13\1\3\0\1\1\11\3\1\1\3\3\1\1"+
    "\26\3\1\1\7\3\1\1\2\3\1\1\5\3\2\1"+
    "\1\0\1\3\10\0\1\1\3\0\1\1\3\0\2\1"+
    "\1\3\17\1\2\3\2\0\2\1\12\0\1\1\1\3"+
    "\7\1\1\3\6\0\1\1\3\0\1\1\10\3\2\1"+
    "\2\3\2\1\26\3\1\1\7\3\1\1\2\3\1\1"+
    "\5\3\2\1\1\0\1\3\7\0\2\1\2\0\2\1"+
    "\3\0\7\1\3\0\4\1\2\3\1\1\3\3\2\0"+
    "\2\1\12\0\1\1\1\3\20\1\1\0\1\3\1\1"+
    "\6\3\3\1\3\3\1\1\4\3\3\1\2\3\1\1"+
    "\1\3\1\1\2\3\3\1\2\3\3\1\3\3\3\1"+
    "\14\3\4\1\5\0\3\1\3\0\1\1\4\0\2\1"+
    "\1\3\6\1\1\0\16\1\12\0\11\1\1\3\6\1"+
    "\5\0\10\3\1\1\3\3\1\1\27\3\1\1\20\3"+
    "\3\1\1\3\7\0\1\1\3\0\1\1\4\0\7\1"+
    "\2\0\1\1\3\3\5\1\2\3\2\0\2\1\12\0"+
    "\20\1\1\3\3\0\1\1\10\3\1\1\3\3\1\1"+
    "\27\3\1\1\12\3\1\1\5\3\2\1\1\0\1\3"+
    "\7\0\1\1\3\0\1\1\4\0\7\1\2\0\7\1"+
    "\1\3\1\1\2\3\2\0\2\1\12\0\1\1\2\3"+
    "\15\1\4\0\11\3\1\1\3\3\1\1\51\3\2\0"+
    "\1\3\7\0\1\1\3\0\1\1\4\0\1\3\5\1"+
    "\3\3\1\0\7\1\3\3\2\0\2\1\12\0\12\1"+
    "\6\3\1\1\3\0\1\1\22\3\3\1\30\3\1\1"+
    "\11\3\1\1\1\3\2\1\7\3\3\1\1\0\4\1"+
    "\6\0\1\1\1\0\1\1\10\0\6\1\12\0\2\1"+
    "\2\0\15\1\60\3\1\0\2\3\7\0\4\1\10\3"+
    "\10\0\1\1\12\0\47\1\2\3\1\1\1\3\1\1"+
    "\5\3\1\1\30\3\1\1\1\3\1\1\12\3\1\0"+
    "\2\3\11\0\1\3\2\1\5\3\1\1\1\3\1\1"+
    "\6\0\2\1\12\0\2\1\4\3\40\1\1\3\27\1"+
    "\2\0\6\1\12\0\13\1\1\0\1\1\1\0\1\1"+
    "\1\0\4\1\2\0\10\3\1\1\44\3\4\1\24\0"+
    "\1\1\2\0\5\3\13\0\1\1\44\0\11\1\1\0"+
    "\71\1\53\3\24\0\1\3\12\0\6\1\6\3\4\0"+
    "\4\3\3\0\1\3\3\0\2\3\7\0\3\3\4\0"+
    "\15\3\14\0\1\3\17\0\2\1\46\3\1\1\1\3"+
    "\5\1\1\3\2\1\53\3\1\1\115\3\1\1\4\3"+
    "\2\1\7\3\1\1\1\3\1\1\4\3\2\1\51\3"+
    "\1\1\4\3\2\1\41\3\1\1\4\3\2\1\7\3"+
    "\1\1\1\3\1\1\4\3\2\1\17\3\1\1\71\3"+
    "\1\1\4\3\2\1\103\3\2\1\3\0\40\1\20\3"+
    "\20\1\126\3\2\1\6\3\3\1\u016c\3\2\1\21\3"+
    "\1\1\32\3\5\1\113\3\3\1\13\3\7\1\15\3"+
    "\1\1\4\3\3\0\13\1\22\3\3\0\13\1\22\3"+
    "\2\0\14\1\15\3\1\1\3\3\1\1\2\0\14\1"+
    "\64\3\40\0\3\1\1\3\3\1\2\3\1\0\2\1"+
    "\12\0\41\1\4\0\1\1\12\0\6\1\131\3\7\1"+
    "\5\3\2\0\42\3\1\0\1\3\5\1\106\3\12\1"+
    "\37\3\1\1\14\0\4\1\14\0\12\1\12\0\36\3"+
    "\2\1\5\3\13\1\54\3\4\1\32\3\6\1\12\0"+
    "\46\1\27\3\5\0\4\1\65\3\12\0\1\1\35\0"+
    "\2\1\13\0\6\1\12\0\15\1\1\3\10\1\16\0"+
    "\1\1\2\0\77\1\5\0\57\3\21\0\7\3\4\1"+
    "\12\0\21\1\11\0\14\1\3\0\36\3\15\0\2\3"+
    "\12\0\54\3\16\0\14\1\44\3\24\0\10\1\12\0"+
    "\3\1\3\3\12\0\44\3\2\1\11\3\7\1\53\3"+
    "\2\1\3\3\20\1\3\0\1\1\25\0\4\3\1\0"+
    "\6\3\1\0\2\3\3\0\1\3\5\1\300\3\72\0"+
    "\1\1\5\0\26\3\2\1\6\3\2\1\46\3\2\1"+
    "\6\3\2\1\10\3\1\1\1\3\1\1\1\3\1\1"+
    "\1\3\1\1\37\3\2\1\65\3\1\1\7\3\1\1"+
    "\1\3\3\1\3\3\1\1\7\3\3\1\4\3\2\1"+
    "\6\3\4\1\15\3\5\1\3\3\1\1\7\3\16\1"+
    "\5\0\32\1\5\0\20\1\2\3\23\1\1\3\13\1"+
    "\5\0\1\1\12\0\1\1\1\3\15\1\1\3\20\1"+
    "\15\3\3\1\40\3\20\1\15\0\4\1\1\0\3\1"+
    "\14\0\21\1\1\3\4\1\1\3\2\1\12\3\1\1"+
    "\1\3\3\1\5\3\6\1\1\3\1\1\1\3\1\1"+
    "\1\3\1\1\4\3\1\1\13\3\2\1\4\3\5\1"+
    "\5\3\4\1\1\3\21\1\51\3\u0177\1\57\3\1\1"+
    "\57\3\1\1\205\3\6\1\4\3\3\0\2\3\14\1"+
    "\46\3\1\1\1\3\5\1\1\3\2\1\70\3\7\1"+
    "\1\3\17\1\1\0\27\3\11\1\7\3\1\1\7\3"+
    "\1\1\7\3\1\1\7\3\1\1\7\3\1\1\7\3"+
    "\1\1\7\3\1\1\7\3\1\1\40\0\57\1\1\3"+
    "\325\1\3\3\31\1\11\3\6\0\1\1\5\3\2\1"+
    "\5\3\4\1\126\3\2\1\2\0\2\1\3\3\1\1"+
    "\132\3\1\1\4\3\5\1\53\3\1\1\136\3\21\1"+
    "\40\3\60\1\320\3\100\1\375\3\3\1\215\3\103\1"+
    "\56\3\2\1\15\3\3\1\20\3\12\0\2\3\24\1"+
    "\57\3\1\0\4\1\12\0\1\1\37\3\2\0\120\3"+
    "\2\0\45\1\11\3\2\1\147\3\2\1\65\3\2\1"+
    "\11\3\52\1\15\3\1\0\3\3\1\0\4\3\1\0"+
    "\27\3\5\0\4\1\1\0\13\1\1\3\7\1\64\3"+
    "\14\1\2\0\62\3\22\0\12\1\12\0\6\1\22\0"+
    "\6\3\3\1\1\3\1\1\2\3\13\0\34\3\10\0"+
    "\2\1\27\3\15\0\14\1\35\3\3\1\4\0\57\3"+
    "\16\0\16\1\1\3\12\0\6\1\5\3\1\0\12\3"+
    "\12\0\5\3\1\1\51\3\16\0\11\1\3\3\1\0"+
    "\10\3\2\0\2\1\12\0\6\1\27\3\3\1\1\3"+
    "\3\0\62\3\1\0\1\3\3\0\2\3\2\0\5\3"+
    "\2\0\1\3\1\0\1\3\30\1\3\3\2\1\13\3"+
    "\5\0\2\1\3\3\2\0\12\1\6\3\2\1\6\3"+
    "\2\1\6\3\11\1\7\3\1\1\7\3\1\1\53\3"+
    "\1\1\16\3\6\1\163\3\10\0\1\1\2\0\2\1"+
    "\12\0\6\1\244\3\14\1\27\3\4\1\61\3\4\1"+
    "\156\3\2\1\152\3\46\1\7\3\14\1\5\3\5\1"+
    "\1\3\1\0\12\3\1\1\15\3\1\1\5\3\1\1"+
    "\1\3\1\1\2\3\1\1\2\3\1\1\154\3\41\1"+
    "\153\3\22\1\100\3\2\1\66\3\50\1\15\3\3\1"+
    "\20\0\20\1\20\0\3\1\2\3\30\1\3\3\31\1"+
    "\1\3\6\1\5\3\1\1\207\3\2\1\1\0\4\1"+
    "\1\3\13\1\12\0\7\1\32\3\4\1\1\3\1\1"+
    "\32\3\13\1\131\3\3\1\6\3\2\1\6\3\2\1"+
    "\6\3\2\1\3\3\3\1\2\3\3\1\2\3\22\1"+
    "\3\0\4\1\14\3\1\1\32\3\1\1\23\3\1\1"+
    "\2\3\1\1\17\3\2\1\16\3\42\1\173\3\105\1"+
    "\65\3\210\1\1\0\202\1\35\3\3\1\61\3\17\1"+
    "\1\0\37\1\40\3\15\1\36\3\5\1\46\3\5\0"+
    "\5\1\36\3\2\1\44\3\4\1\10\3\1\1\5\3"+
    "\52\1\236\3\2\1\12\0\6\1\44\3\4\1\44\3"+
    "\4\1\50\3\10\1\64\3\234\1\67\3\11\1\26\3"+
    "\12\1\10\3\230\1\6\3\2\1\1\3\1\1\54\3"+
    "\1\1\2\3\3\1\1\3\2\1\27\3\12\1\27\3"+
    "\11\1\37\3\101\1\23\3\1\1\2\3\12\1\26\3"+
    "\12\1\32\3\106\1\70\3\6\1\2\3\100\1\1\3"+
    "\3\0\1\1\2\0\5\1\4\0\4\3\1\1\3\3"+
    "\1\1\35\3\2\1\3\0\4\1\1\0\40\1\35\3"+
    "\3\1\35\3\43\1\10\3\1\1\34\3\2\0\31\1"+
    "\66\3\12\1\26\3\12\1\23\3\15\1\22\3\156\1"+
    "\111\3\67\1\63\3\15\1\63\3\15\1\44\3\4\0"+
    "\10\1\12\0\u0146\1\52\3\1\1\2\0\3\1\2\3"+
    "\116\1\35\3\12\1\1\3\10\1\26\3\13\0\137\1"+
    "\25\3\33\1\27\3\11\1\3\0\65\3\17\0\37\1"+
    "\12\0\17\1\4\0\55\3\13\0\2\1\1\0\17\1"+
    "\1\0\2\1\31\3\7\1\12\0\6\1\3\0\44\3"+
    "\16\0\1\1\12\0\4\1\1\3\2\0\1\3\10\1"+
    "\43\3\1\0\2\1\1\3\11\1\3\0\60\3\16\0"+
    "\4\3\4\1\4\0\1\1\14\0\1\3\1\1\1\3"+
    "\43\1\22\3\1\1\31\3\14\0\6\1\1\0\101\1"+
    "\7\3\1\1\1\3\1\1\4\3\1\1\17\3\1\1"+
    "\12\3\7\1\57\3\14\0\5\1\12\0\6\1\4\0"+
    "\1\1\10\3\2\1\2\3\2\1\26\3\1\1\7\3"+
    "\1\1\2\3\1\1\5\3\1\1\2\0\1\3\7\0"+
    "\2\1\2\0\2\1\3\0\2\1\1\3\6\1\1\0"+
    "\5\1\5\3\2\0\2\1\7\0\3\1\5\0\213\1"+
    "\65\3\22\0\4\3\5\1\12\0\4\1\1\0\3\3"+
    "\36\1\60\3\24\0\2\3\1\1\1\3\10\1\12\0"+
    "\246\1\57\3\7\0\2\1\11\0\27\1\4\3\2\0"+
    "\42\1\60\3\21\0\3\1\1\3\13\1\12\0\46\1"+
    "\53\3\15\0\1\3\7\1\12\0\66\1\33\3\2\1"+
    "\17\0\4\1\12\0\306\1\54\3\17\0\145\1\100\3"+
    "\12\0\25\1\10\3\2\1\1\3\2\1\10\3\1\1"+
    "\2\3\1\1\30\3\6\0\1\1\2\0\2\1\4\0"+
    "\1\3\1\0\1\3\2\0\14\1\12\0\106\1\10\3"+
    "\2\1\47\3\7\0\2\1\7\0\1\3\1\1\1\3"+
    "\1\0\33\1\1\3\12\0\50\3\7\0\1\3\4\0"+
    "\10\1\1\0\10\1\1\3\13\0\56\3\20\0\3\1"+
    "\1\3\42\1\71\3\7\1\11\3\1\1\45\3\10\0"+
    "\1\1\10\0\1\3\17\1\12\0\30\1\36\3\2\1"+
    "\26\0\1\1\16\0\111\1\7\3\1\1\2\3\1\1"+
    "\46\3\6\0\3\1\1\0\1\1\2\0\1\1\7\0"+
    "\1\3\1\0\10\1\12\0\6\1\6\3\1\1\2\3"+
    "\1\1\40\3\5\0\1\1\2\0\1\1\5\0\1\3"+
    "\7\1\12\0\u0136\1\23\3\4\0\271\1\1\3\54\1"+
    "\4\3\37\1\232\3\146\1\157\3\21\1\304\3\274\1"+
    "\57\3\1\1\11\0\307\1\107\3\271\1\71\3\7\1"+
    "\37\3\1\1\12\0\146\1\36\3\2\1\5\0\13\1"+
    "\60\3\7\0\11\1\4\3\14\1\12\0\11\1\25\3"+
    "\5\1\23\3\260\1\100\3\200\1\113\3\4\1\1\0"+
    "\1\3\67\0\7\1\4\0\15\3\100\1\2\3\1\1"+
    "\1\3\1\0\13\1\2\0\16\1\370\3\10\1\326\3"+
    "\52\1\11\3\367\1\37\3\61\1\3\3\21\1\4\3"+
    "\10\1\u018c\3\4\1\153\3\5\1\15\3\3\1\11\3"+
    "\7\1\12\3\3\1\2\0\1\1\4\0\301\1\5\0"+
    "\3\1\26\0\2\1\7\0\36\1\4\0\224\1\3\0"+
    "\273\1\125\3\1\1\107\3\1\1\2\3\2\1\1\3"+
    "\2\1\2\3\2\1\4\3\1\1\14\3\1\1\1\3"+
    "\1\1\7\3\1\1\101\3\1\1\4\3\2\1\10\3"+
    "\1\1\7\3\1\1\34\3\1\1\4\3\1\1\5\3"+
    "\1\1\1\3\3\1\7\3\1\1\u0154\3\2\1\31\3"+
    "\1\1\31\3\1\1\37\3\1\1\31\3\1\1\37\3"+
    "\1\1\31\3\1\1\37\3\1\1\31\3\1\1\37\3"+
    "\1\1\31\3\1\1\10\3\2\1\151\0\4\1\62\0"+
    "\10\1\1\0\16\1\1\0\26\1\5\0\1\1\17\0"+
    "\120\1\7\0\1\1\21\0\2\1\7\0\1\1\2\0"+
    "\1\1\5\0\325\1\55\3\3\1\7\0\7\3\2\1"+
    "\12\0\4\1\1\3\u0171\1\54\3\16\0\5\1\306\3"+
    "\13\1\7\0\51\1\104\3\7\0\1\3\4\1\12\0"+
    "\u0156\1\1\3\117\1\4\3\1\1\33\3\1\1\2\3"+
    "\1\1\1\3\2\1\1\3\1\1\12\3\1\1\4\3"+
    "\1\1\1\3\1\1\1\3\6\1\1\3\4\1\1\3"+
    "\1\1\1\3\1\1\1\3\1\1\3\3\1\1\2\3"+
    "\1\1\1\3\2\1\1\3\1\1\1\3\1\1\1\3"+
    "\1\1\1\3\1\1\1\3\1\1\2\3\1\1\1\3"+
    "\2\1\4\3\1\1\7\3\1\1\4\3\1\1\4\3"+
    "\1\1\1\3\1\1\12\3\1\1\21\3\5\1\3\3"+
    "\1\1\5\3\1\1\21\3\u0134\1\12\0\6\1\336\3"+
    "\42\1\65\3\13\1\336\3\2\1\u0182\3\16\1\u0131\3"+
    "\37\1\36\3\342\1\113\3\266\1\1\0\36\1\140\0"+
    "\200\1\360\0\20\1";

  private static int [] zzUnpackcmap_blocks() {
    int [] result = new int[30976];
    int offset = 0;
    offset = zzUnpackcmap_blocks(ZZ_CMAP_BLOCKS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackcmap_blocks(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /**
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\1\0\1\1\1\2\1\3\1\4\1\5\1\6\1\7"+
    "\1\10\1\11\1\12\1\13\1\14\1\15\2\16\1\17"+
    "\1\20\1\21\1\22\1\23\1\24\1\25\1\26\1\27"+
    "\1\30\20\3\1\31\1\32\1\33\1\34\1\35\1\36"+
    "\1\37\1\40\1\41\1\42\1\43\1\44\1\45\1\46"+
    "\1\0\1\47\1\50\1\16\2\47\1\51\1\52\1\16"+
    "\1\53\1\54\1\55\1\56\1\57\12\3\1\60\10\3"+
    "\1\61\23\3\1\62\1\63\1\64\1\47\1\0\1\16"+
    "\1\65\22\3\1\66\3\3\1\67\2\3\1\70\20\3"+
    "\1\71\3\3\1\0\4\3\1\72\1\73\1\3\1\74"+
    "\5\3\1\75\1\76\4\3\1\77\4\3\1\100\1\3"+
    "\1\101\13\3\1\102\2\3\1\103\1\104\5\3\1\105"+
    "\1\106\1\107\1\110\4\3\1\111\1\112\1\113\12\3"+
    "\1\114\2\3\1\115\2\3\1\116\2\3\1\117\1\3"+
    "\1\120\3\3\1\121\3\3\1\122\2\3\1\123\3\3"+
    "\1\124\1\125\1\126\1\3\1\127\1\3\1\130\3\3"+
    "\1\131\1\3\1\132\1\133\1\134\3\3\1\135\1\136"+
    "\5\3\1\137\1\140\4\3\1\141\2\3\1\142\2\3"+
    "\1\143\1\144\1\3\1\145\1\146\1\147\2\3\1\150";

  private static int [] zzUnpackAction() {
    int [] result = new int[304];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /**
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\77\0\176\0\275\0\374\0\u013b\0\77\0\77"+
    "\0\u017a\0\u01b9\0\77\0\u01f8\0\u0237\0\u0276\0\u02b5\0\u02f4"+
    "\0\u0333\0\77\0\u0372\0\u03b1\0\77\0\77\0\77\0\77"+
    "\0\77\0\u03f0\0\u042f\0\u046e\0\u04ad\0\u04ec\0\u052b\0\u056a"+
    "\0\u05a9\0\u05e8\0\u0627\0\u0666\0\u06a5\0\u06e4\0\u0723\0\u0762"+
    "\0\u07a1\0\u07e0\0\77\0\u081f\0\77\0\77\0\77\0\77"+
    "\0\77\0\77\0\77\0\77\0\77\0\77\0\77\0\77"+
    "\0\u085e\0\u089d\0\77\0\u08dc\0\77\0\u091b\0\77\0\77"+
    "\0\u095a\0\77\0\u0999\0\77\0\77\0\77\0\u09d8\0\u0a17"+
    "\0\u0a56\0\u0a95\0\u0ad4\0\u0b13\0\u0b52\0\u0b91\0\u0bd0\0\u0c0f"+
    "\0\u0c4e\0\u0c8d\0\u0ccc\0\u0d0b\0\u0d4a\0\u0d89\0\u0dc8\0\u0e07"+
    "\0\u0e46\0\275\0\u0e85\0\u0ec4\0\u0f03\0\u0f42\0\u0f81\0\u0fc0"+
    "\0\u0fff\0\u103e\0\u107d\0\u10bc\0\u10fb\0\u113a\0\u1179\0\u11b8"+
    "\0\u11f7\0\u1236\0\u1275\0\u12b4\0\u12f3\0\77\0\77\0\77"+
    "\0\u1332\0\u1371\0\u13b0\0\77\0\u13ef\0\u142e\0\u146d\0\u14ac"+
    "\0\u14eb\0\u152a\0\u1569\0\u15a8\0\u15e7\0\u1626\0\u1665\0\u16a4"+
    "\0\u16e3\0\u1722\0\u1761\0\u17a0\0\u17df\0\u181e\0\275\0\u185d"+
    "\0\u189c\0\u18db\0\u191a\0\u1959\0\u1998\0\275\0\u19d7\0\u1a16"+
    "\0\u1a55\0\u1a94\0\u1ad3\0\u1b12\0\u1b51\0\u1b90\0\u1bcf\0\u1c0e"+
    "\0\u1c4d\0\u1c8c\0\u1ccb\0\u1d0a\0\u1d49\0\u1d88\0\275\0\u1dc7"+
    "\0\u1e06\0\u1e45\0\u1e84\0\u1ec3\0\u1f02\0\u1f41\0\u1f80\0\275"+
    "\0\275\0\u1fbf\0\275\0\u1ffe\0\u203d\0\u207c\0\u20bb\0\u20fa"+
    "\0\275\0\275\0\u2139\0\u2178\0\u21b7\0\u21f6\0\275\0\u2235"+
    "\0\u2274\0\u22b3\0\u22f2\0\275\0\u2331\0\275\0\u2370\0\u23af"+
    "\0\u23ee\0\u242d\0\u246c\0\u24ab\0\u24ea\0\u2529\0\u2568\0\u25a7"+
    "\0\u25e6\0\275\0\u2625\0\u2664\0\275\0\275\0\u26a3\0\u26e2"+
    "\0\u2721\0\u2760\0\u279f\0\275\0\275\0\275\0\275\0\u27de"+
    "\0\u281d\0\u285c\0\u289b\0\275\0\u28da\0\275\0\u2919\0\u2958"+
    "\0\u2997\0\u29d6\0\u2a15\0\u2a54\0\u2a93\0\u2ad2\0\u2b11\0\u2b50"+
    "\0\275\0\u2b8f\0\u2bce\0\275\0\u2c0d\0\u2c4c\0\u2c8b\0\u2cca"+
    "\0\u2d09\0\275\0\u2d48\0\275\0\u2d87\0\u2dc6\0\u2e05\0\275"+
    "\0\u2e44\0\u2e83\0\u2ec2\0\275\0\u2f01\0\u2f40\0\275\0\u2f7f"+
    "\0\u2fbe\0\u2ffd\0\275\0\275\0\275\0\u303c\0\275\0\u307b"+
    "\0\275\0\u30ba\0\u30f9\0\u3138\0\275\0\u3177\0\275\0\275"+
    "\0\275\0\u31b6\0\u31f5\0\u3234\0\275\0\275\0\u3273\0\u32b2"+
    "\0\u32f1\0\u3330\0\u336f\0\275\0\275\0\u33ae\0\u33ed\0\u342c"+
    "\0\u346b\0\275\0\u34aa\0\u34e9\0\275\0\u3528\0\u3567\0\275"+
    "\0\275\0\u35a6\0\275\0\275\0\275\0\u35e5\0\u3624\0\275";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[304];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length() - 1;
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /**
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpacktrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\2\2\1\3\1\4\1\5\1\6\1\7\1\10\1\11"+
    "\1\12\1\13\1\14\1\15\1\16\1\17\1\20\1\21"+
    "\1\22\1\23\1\24\1\25\1\26\1\27\10\4\1\30"+
    "\1\31\1\32\1\4\1\33\1\34\1\35\1\36\1\37"+
    "\1\40\1\41\1\4\1\42\1\4\1\43\1\4\1\44"+
    "\1\4\1\45\1\46\1\47\1\50\1\4\1\51\1\52"+
    "\3\4\1\53\1\54\1\55\1\56\122\0\1\57\53\0"+
    "\1\4\2\0\1\4\12\0\2\4\7\0\10\4\3\0"+
    "\31\4\27\0\1\60\60\0\1\61\15\0\1\62\76\0"+
    "\1\63\64\0\1\64\11\0\1\65\66\0\1\66\7\0"+
    "\1\67\1\70\66\0\1\71\1\0\2\72\102\0\1\73"+
    "\67\0\1\72\1\0\2\20\10\0\1\74\1\75\1\76"+
    "\1\77\1\100\1\0\1\101\3\0\1\20\1\0\1\74"+
    "\1\0\1\75\1\76\1\77\4\0\1\100\12\0\1\101"+
    "\22\0\1\72\1\0\2\20\11\0\1\75\1\76\1\77"+
    "\1\100\5\0\1\20\3\0\1\75\1\76\1\77\4\0"+
    "\1\100\41\0\1\102\100\0\1\103\1\104\76\0\1\105"+
    "\76\0\1\106\53\0\1\4\2\0\1\4\12\0\2\4"+
    "\7\0\10\4\3\0\2\4\1\107\16\4\1\110\7\4"+
    "\4\0\1\4\2\0\1\4\12\0\2\4\7\0\10\4"+
    "\3\0\16\4\1\111\1\4\1\112\6\4\1\113\1\4"+
    "\4\0\1\4\2\0\1\4\12\0\2\4\7\0\10\4"+
    "\3\0\1\4\1\114\6\4\1\115\2\4\1\116\2\4"+
    "\1\117\12\4\4\0\1\4\2\0\1\4\12\0\2\4"+
    "\7\0\10\4\3\0\5\4\1\120\10\4\1\121\12\4"+
    "\4\0\1\4\2\0\1\4\12\0\2\4\7\0\10\4"+
    "\3\0\13\4\1\122\1\4\1\123\10\4\1\124\2\4"+
    "\4\0\1\4\2\0\1\4\12\0\2\4\7\0\10\4"+
    "\3\0\1\4\1\125\7\4\1\126\1\4\1\127\2\4"+
    "\1\130\12\4\4\0\1\4\2\0\1\4\12\0\2\4"+
    "\7\0\10\4\3\0\16\4\1\131\12\4\4\0\1\4"+
    "\2\0\1\4\12\0\2\4\7\0\10\4\3\0\6\4"+
    "\1\132\5\4\1\133\1\134\13\4\4\0\1\4\2\0"+
    "\1\4\12\0\2\4\7\0\10\4\3\0\16\4\1\135"+
    "\12\4\4\0\1\4\2\0\1\4\12\0\2\4\7\0"+
    "\10\4\3\0\1\4\1\136\3\4\1\137\15\4\1\140"+
    "\5\4\4\0\1\4\2\0\1\4\12\0\2\4\7\0"+
    "\10\4\3\0\1\4\1\141\16\4\1\142\2\4\1\143"+
    "\5\4\4\0\1\4\2\0\1\4\12\0\2\4\7\0"+
    "\10\4\3\0\5\4\1\144\23\4\4\0\1\4\2\0"+
    "\1\4\12\0\2\4\7\0\10\4\3\0\10\4\1\145"+
    "\11\4\1\146\1\147\1\4\1\150\1\4\1\151\1\4"+
    "\4\0\1\4\2\0\1\4\12\0\2\4\7\0\10\4"+
    "\3\0\10\4\1\152\7\4\1\153\10\4\4\0\1\4"+
    "\2\0\1\4\12\0\2\4\7\0\10\4\3\0\16\4"+
    "\1\154\12\4\4\0\1\4\2\0\1\4\12\0\2\4"+
    "\7\0\10\4\3\0\10\4\1\155\20\4\27\0\1\156"+
    "\50\0\1\157\16\0\1\160\100\0\2\72\11\0\1\75"+
    "\1\76\1\77\6\0\1\72\3\0\1\75\1\76\1\77"+
    "\44\0\2\74\14\0\1\100\5\0\1\74\12\0\1\100"+
    "\32\0\1\161\1\0\1\161\2\0\2\161\11\0\1\75"+
    "\1\0\1\77\6\0\1\161\3\0\1\75\1\0\1\77"+
    "\42\0\1\162\1\0\2\163\7\0\5\163\1\100\5\0"+
    "\7\163\4\0\1\100\44\0\1\164\53\0\1\4\2\0"+
    "\1\4\12\0\2\4\7\0\10\4\3\0\21\4\1\165"+
    "\7\4\4\0\1\4\2\0\1\4\12\0\2\4\7\0"+
    "\10\4\3\0\21\4\1\166\7\4\4\0\1\4\2\0"+
    "\1\4\12\0\2\4\7\0\10\4\3\0\16\4\1\167"+
    "\12\4\4\0\1\4\2\0\1\4\12\0\2\4\7\0"+
    "\10\4\3\0\5\4\1\170\23\4\4\0\1\4\2\0"+
    "\1\4\12\0\2\4\7\0\10\4\3\0\22\4\1\171"+
    "\6\4\4\0\1\4\2\0\1\4\12\0\2\4\7\0"+
    "\10\4\3\0\21\4\1\172\1\173\6\4\4\0\1\4"+
    "\2\0\1\4\12\0\2\4\7\0\10\4\3\0\1\4"+
    "\1\174\27\4\4\0\1\4\2\0\1\4\12\0\2\4"+
    "\7\0\10\4\3\0\1\4\1\175\27\4\4\0\1\4"+
    "\2\0\1\4\12\0\2\4\7\0\10\4\3\0\15\4"+
    "\1\176\13\4\4\0\1\4\2\0\1\4\12\0\2\4"+
    "\7\0\10\4\3\0\6\4\1\177\22\4\4\0\1\4"+
    "\2\0\1\4\12\0\2\4\7\0\10\4\3\0\23\4"+
    "\1\200\5\4\4\0\1\4\2\0\1\4\12\0\2\4"+
    "\7\0\10\4\3\0\21\4\1\201\7\4\4\0\1\4"+
    "\2\0\1\4\12\0\2\4\7\0\10\4\3\0\23\4"+
    "\1\202\5\4\4\0\1\4\2\0\1\4\12\0\2\4"+
    "\7\0\10\4\3\0\22\4\1\203\6\4\4\0\1\4"+
    "\2\0\1\4\12\0\2\4\7\0\10\4\3\0\13\4"+
    "\1\204\15\4\4\0\1\4\2\0\1\4\12\0\2\4"+
    "\7\0\10\4\3\0\15\4\1\205\13\4\4\0\1\4"+
    "\2\0\1\4\12\0\2\4\7\0\10\4\3\0\16\4"+
    "\1\206\12\4\4\0\1\4\2\0\1\4\12\0\2\4"+
    "\7\0\10\4\3\0\20\4\1\207\10\4\4\0\1\4"+
    "\2\0\1\4\12\0\2\4\7\0\10\4\3\0\22\4"+
    "\1\210\6\4\4\0\1\4\2\0\1\4\12\0\2\4"+
    "\7\0\10\4\3\0\17\4\1\211\11\4\4\0\1\4"+
    "\2\0\1\4\12\0\2\4\7\0\10\4\3\0\21\4"+
    "\1\212\1\213\6\4\4\0\1\4\2\0\1\4\12\0"+
    "\2\4\7\0\10\4\3\0\15\4\1\214\13\4\4\0"+
    "\1\4\2\0\1\4\12\0\2\4\7\0\10\4\3\0"+
    "\22\4\1\215\6\4\4\0\1\4\2\0\1\4\12\0"+
    "\2\4\7\0\10\4\3\0\25\4\1\216\3\4\4\0"+
    "\1\4\2\0\1\4\12\0\2\4\7\0\10\4\3\0"+
    "\13\4\1\217\15\4\4\0\1\4\2\0\1\4\12\0"+
    "\2\4\7\0\10\4\3\0\3\4\1\220\25\4\4\0"+
    "\1\4\2\0\1\4\12\0\2\4\7\0\10\4\3\0"+
    "\11\4\1\221\4\4\1\222\12\4\4\0\1\4\2\0"+
    "\1\4\12\0\2\4\7\0\10\4\3\0\2\4\1\223"+
    "\26\4\4\0\1\4\2\0\1\4\12\0\2\4\7\0"+
    "\10\4\3\0\22\4\1\224\6\4\4\0\1\4\2\0"+
    "\1\4\12\0\2\4\7\0\10\4\3\0\16\4\1\225"+
    "\12\4\4\0\1\4\2\0\1\4\12\0\2\4\7\0"+
    "\10\4\3\0\1\4\1\226\16\4\1\227\10\4\4\0"+
    "\1\4\2\0\1\4\12\0\2\4\7\0\10\4\3\0"+
    "\17\4\1\230\11\4\4\0\1\4\2\0\1\4\12\0"+
    "\2\4\7\0\10\4\3\0\11\4\1\231\17\4\4\0"+
    "\1\4\2\0\1\4\12\0\2\4\7\0\10\4\3\0"+
    "\15\4\1\232\13\4\4\0\1\4\2\0\1\4\12\0"+
    "\2\4\7\0\10\4\3\0\11\4\1\233\6\4\1\234"+
    "\10\4\4\0\1\4\2\0\1\4\12\0\2\4\7\0"+
    "\10\4\3\0\1\4\1\235\21\4\1\236\3\4\1\237"+
    "\1\4\4\0\1\4\2\0\1\4\12\0\2\4\7\0"+
    "\10\4\3\0\11\4\1\240\1\4\1\241\15\4\4\0"+
    "\1\4\2\0\1\4\12\0\2\4\7\0\10\4\3\0"+
    "\11\4\1\242\17\4\22\0\2\161\11\0\1\75\1\0"+
    "\1\77\6\0\1\161\3\0\1\75\1\0\1\77\44\0"+
    "\2\243\7\0\5\243\6\0\7\243\42\0\1\243\1\0"+
    "\2\163\7\0\5\163\1\100\1\76\4\0\7\163\4\0"+
    "\1\100\3\0\1\76\15\0\1\4\2\0\1\4\12\0"+
    "\2\4\7\0\10\4\3\0\22\4\1\244\6\4\4\0"+
    "\1\4\2\0\1\4\12\0\2\4\7\0\10\4\3\0"+
    "\5\4\1\245\23\4\4\0\1\4\2\0\1\4\12\0"+
    "\2\4\7\0\10\4\3\0\13\4\1\246\15\4\4\0"+
    "\1\4\2\0\1\4\12\0\2\4\7\0\10\4\3\0"+
    "\1\4\1\247\27\4\4\0\1\4\2\0\1\4\12\0"+
    "\2\4\7\0\10\4\3\0\5\4\1\250\23\4\4\0"+
    "\1\4\2\0\1\4\12\0\2\4\7\0\10\4\3\0"+
    "\5\4\1\251\23\4\4\0\1\4\2\0\1\4\12\0"+
    "\2\4\7\0\10\4\3\0\3\4\1\252\25\4\4\0"+
    "\1\4\2\0\1\4\12\0\2\4\7\0\10\4\3\0"+
    "\20\4\1\253\10\4\4\0\1\4\2\0\1\4\12\0"+
    "\2\4\7\0\10\4\3\0\21\4\1\254\7\4\4\0"+
    "\1\4\2\0\1\4\12\0\2\4\7\0\10\4\3\0"+
    "\21\4\1\255\1\256\6\4\4\0\1\4\2\0\1\4"+
    "\12\0\2\4\7\0\10\4\3\0\1\4\1\257\27\4"+
    "\4\0\1\4\2\0\1\4\12\0\2\4\7\0\10\4"+
    "\3\0\2\4\1\260\26\4\4\0\1\4\2\0\1\4"+
    "\12\0\2\4\7\0\10\4\3\0\5\4\1\261\23\4"+
    "\4\0\1\4\2\0\1\4\12\0\2\4\7\0\10\4"+
    "\3\0\14\4\1\262\14\4\4\0\1\4\2\0\1\4"+
    "\12\0\2\4\7\0\10\4\3\0\5\4\1\263\23\4"+
    "\4\0\1\4\2\0\1\4\12\0\2\4\7\0\10\4"+
    "\3\0\21\4\1\264\7\4\4\0\1\4\2\0\1\4"+
    "\12\0\2\4\7\0\10\4\3\0\1\4\1\265\27\4"+
    "\4\0\1\4\2\0\1\4\12\0\2\4\7\0\10\4"+
    "\3\0\1\4\1\266\27\4\4\0\1\4\2\0\1\4"+
    "\12\0\2\4\7\0\10\4\3\0\16\4\1\267\12\4"+
    "\4\0\1\4\2\0\1\4\12\0\2\4\7\0\10\4"+
    "\3\0\13\4\1\270\2\4\1\271\12\4\4\0\1\4"+
    "\2\0\1\4\12\0\2\4\7\0\10\4\3\0\22\4"+
    "\1\272\6\4\4\0\1\4\2\0\1\4\12\0\2\4"+
    "\7\0\10\4\3\0\5\4\1\273\23\4\4\0\1\4"+
    "\2\0\1\4\12\0\2\4\7\0\10\4\3\0\7\4"+
    "\1\274\21\4\4\0\1\4\2\0\1\4\12\0\2\4"+
    "\7\0\10\4\3\0\11\4\1\275\17\4\4\0\1\4"+
    "\2\0\1\4\12\0\2\4\7\0\10\4\3\0\13\4"+
    "\1\276\15\4\4\0\1\4\2\0\1\4\12\0\2\4"+
    "\7\0\10\4\3\0\12\4\1\277\16\4\4\0\1\4"+
    "\2\0\1\4\12\0\2\4\7\0\10\4\3\0\24\4"+
    "\1\300\4\4\4\0\1\4\2\0\1\4\12\0\2\4"+
    "\7\0\10\4\3\0\22\4\1\301\6\4\4\0\1\4"+
    "\2\0\1\4\12\0\2\4\7\0\10\4\3\0\13\4"+
    "\1\302\15\4\4\0\1\4\2\0\1\4\12\0\2\4"+
    "\7\0\10\4\3\0\23\4\1\303\5\4\4\0\1\4"+
    "\2\0\1\4\12\0\2\4\7\0\10\4\3\0\20\4"+
    "\1\304\10\4\4\0\1\4\2\0\1\4\12\0\2\4"+
    "\7\0\10\4\3\0\22\4\1\305\6\4\4\0\1\4"+
    "\2\0\1\4\12\0\2\4\7\0\10\4\3\0\11\4"+
    "\1\306\17\4\4\0\1\4\2\0\1\4\12\0\2\4"+
    "\7\0\10\4\3\0\5\4\1\307\23\4\4\0\1\4"+
    "\2\0\1\4\12\0\2\4\7\0\10\4\3\0\22\4"+
    "\1\310\6\4\4\0\1\4\2\0\1\4\12\0\2\4"+
    "\7\0\10\4\3\0\3\4\1\311\25\4\4\0\1\4"+
    "\2\0\1\4\12\0\2\4\7\0\10\4\3\0\21\4"+
    "\1\312\7\4\4\0\1\4\2\0\1\4\12\0\2\4"+
    "\7\0\10\4\3\0\16\4\1\313\12\4\4\0\1\4"+
    "\2\0\1\4\12\0\2\4\7\0\10\4\3\0\15\4"+
    "\1\314\13\4\4\0\1\4\2\0\1\4\12\0\2\4"+
    "\7\0\10\4\3\0\5\4\1\315\23\4\4\0\1\4"+
    "\2\0\1\4\12\0\2\4\7\0\10\4\3\0\4\4"+
    "\1\316\24\4\4\0\1\4\2\0\1\4\12\0\2\4"+
    "\7\0\10\4\3\0\1\4\1\317\27\4\4\0\1\4"+
    "\2\0\1\4\12\0\2\4\7\0\10\4\3\0\13\4"+
    "\1\320\15\4\22\0\2\243\7\0\5\243\1\0\1\76"+
    "\4\0\7\243\10\0\1\76\15\0\1\4\2\0\1\4"+
    "\12\0\2\4\7\0\10\4\3\0\20\4\1\321\10\4"+
    "\4\0\1\4\2\0\1\4\12\0\2\4\7\0\10\4"+
    "\3\0\20\4\1\322\10\4\4\0\1\4\2\0\1\4"+
    "\12\0\2\4\7\0\10\4\3\0\5\4\1\323\23\4"+
    "\4\0\1\4\2\0\1\4\12\0\2\4\7\0\10\4"+
    "\3\0\12\4\1\324\16\4\4\0\1\4\2\0\1\4"+
    "\12\0\2\4\7\0\10\4\3\0\10\4\1\325\20\4"+
    "\4\0\1\4\2\0\1\4\12\0\2\4\7\0\10\4"+
    "\3\0\21\4\1\326\7\4\4\0\1\4\2\0\1\4"+
    "\12\0\2\4\7\0\10\4\3\0\22\4\1\327\6\4"+
    "\4\0\1\4\2\0\1\4\12\0\2\4\7\0\10\4"+
    "\3\0\11\4\1\330\17\4\4\0\1\4\2\0\1\4"+
    "\12\0\2\4\7\0\10\4\3\0\23\4\1\331\5\4"+
    "\4\0\1\4\2\0\1\4\12\0\2\4\7\0\10\4"+
    "\3\0\13\4\1\332\15\4\4\0\1\4\2\0\1\4"+
    "\12\0\2\4\7\0\10\4\3\0\15\4\1\333\13\4"+
    "\4\0\1\4\2\0\1\4\12\0\2\4\7\0\10\4"+
    "\3\0\5\4\1\334\23\4\4\0\1\4\2\0\1\4"+
    "\12\0\2\4\7\0\10\4\3\0\13\4\1\335\15\4"+
    "\4\0\1\4\2\0\1\4\12\0\2\4\7\0\10\4"+
    "\3\0\22\4\1\336\6\4\4\0\1\4\2\0\1\4"+
    "\12\0\2\4\7\0\10\4\3\0\5\4\1\337\23\4"+
    "\4\0\1\4\2\0\1\4\12\0\2\4\7\0\10\4"+
    "\3\0\20\4\1\340\10\4\4\0\1\4\2\0\1\4"+
    "\12\0\2\4\7\0\10\4\3\0\1\4\1\341\27\4"+
    "\4\0\1\4\2\0\1\4\12\0\2\4\7\0\10\4"+
    "\3\0\20\4\1\342\10\4\4\0\1\4\2\0\1\4"+
    "\12\0\2\4\7\0\10\4\3\0\24\4\1\343\4\4"+
    "\4\0\1\4\2\0\1\4\12\0\2\4\7\0\10\4"+
    "\3\0\1\4\1\344\27\4\4\0\1\4\2\0\1\4"+
    "\12\0\2\4\7\0\10\4\3\0\1\4\1\345\27\4"+
    "\4\0\1\4\2\0\1\4\12\0\2\4\7\0\10\4"+
    "\3\0\5\4\1\346\23\4\4\0\1\4\2\0\1\4"+
    "\12\0\2\4\7\0\10\4\3\0\11\4\1\347\17\4"+
    "\4\0\1\4\2\0\1\4\12\0\2\4\7\0\10\4"+
    "\3\0\20\4\1\350\10\4\4\0\1\4\2\0\1\4"+
    "\12\0\2\4\7\0\10\4\3\0\22\4\1\351\6\4"+
    "\4\0\1\4\2\0\1\4\12\0\2\4\7\0\10\4"+
    "\3\0\11\4\1\352\17\4\4\0\1\4\2\0\1\4"+
    "\12\0\2\4\7\0\10\4\3\0\3\4\1\353\25\4"+
    "\4\0\1\4\2\0\1\4\12\0\2\4\7\0\10\4"+
    "\3\0\20\4\1\354\10\4\4\0\1\4\2\0\1\4"+
    "\12\0\2\4\7\0\10\4\3\0\3\4\1\355\25\4"+
    "\4\0\1\4\2\0\1\4\12\0\2\4\7\0\10\4"+
    "\3\0\10\4\1\356\20\4\4\0\1\4\2\0\1\4"+
    "\12\0\2\4\7\0\10\4\3\0\25\4\1\357\3\4"+
    "\4\0\1\4\2\0\1\4\12\0\2\4\7\0\10\4"+
    "\3\0\21\4\1\360\7\4\4\0\1\4\2\0\1\4"+
    "\12\0\2\4\7\0\10\4\3\0\22\4\1\361\6\4"+
    "\4\0\1\4\2\0\1\4\12\0\2\4\7\0\10\4"+
    "\3\0\5\4\1\362\23\4\4\0\1\4\2\0\1\4"+
    "\12\0\2\4\7\0\10\4\3\0\1\4\1\363\27\4"+
    "\4\0\1\4\2\0\1\4\12\0\2\4\7\0\10\4"+
    "\3\0\22\4\1\364\6\4\4\0\1\4\2\0\1\4"+
    "\12\0\2\4\7\0\10\4\3\0\1\4\1\365\27\4"+
    "\4\0\1\4\2\0\1\4\12\0\2\4\7\0\10\4"+
    "\3\0\15\4\1\366\13\4\4\0\1\4\2\0\1\4"+
    "\12\0\2\4\7\0\10\4\3\0\13\4\1\367\15\4"+
    "\4\0\1\4\2\0\1\4\12\0\2\4\7\0\10\4"+
    "\3\0\5\4\1\370\23\4\4\0\1\4\2\0\1\4"+
    "\12\0\2\4\7\0\10\4\3\0\4\4\1\371\24\4"+
    "\4\0\1\4\2\0\1\4\12\0\2\4\7\0\10\4"+
    "\3\0\13\4\1\372\15\4\4\0\1\4\2\0\1\4"+
    "\12\0\2\4\7\0\10\4\3\0\14\4\1\373\14\4"+
    "\4\0\1\4\2\0\1\4\12\0\2\4\7\0\10\4"+
    "\3\0\22\4\1\374\6\4\4\0\1\4\2\0\1\4"+
    "\12\0\2\4\7\0\10\4\3\0\15\4\1\375\13\4"+
    "\4\0\1\4\2\0\1\4\12\0\2\4\7\0\10\4"+
    "\3\0\6\4\1\376\22\4\4\0\1\4\2\0\1\4"+
    "\12\0\2\4\7\0\10\4\3\0\5\4\1\377\23\4"+
    "\4\0\1\4\2\0\1\4\12\0\2\4\7\0\10\4"+
    "\3\0\7\4\1\u0100\21\4\4\0\1\4\2\0\1\4"+
    "\12\0\2\4\7\0\10\4\3\0\22\4\1\u0101\6\4"+
    "\4\0\1\4\2\0\1\4\12\0\2\4\7\0\10\4"+
    "\3\0\3\4\1\u0102\25\4\4\0\1\4\2\0\1\4"+
    "\12\0\2\4\7\0\10\4\3\0\3\4\1\u0103\25\4"+
    "\4\0\1\4\2\0\1\4\12\0\2\4\7\0\10\4"+
    "\3\0\15\4\1\u0104\13\4\4\0\1\4\2\0\1\4"+
    "\12\0\2\4\7\0\10\4\3\0\3\4\1\u0105\25\4"+
    "\4\0\1\4\2\0\1\4\12\0\2\4\7\0\10\4"+
    "\3\0\22\4\1\u0106\6\4\4\0\1\4\2\0\1\4"+
    "\12\0\2\4\7\0\10\4\3\0\10\4\1\u0107\20\4"+
    "\4\0\1\4\2\0\1\4\12\0\2\4\7\0\10\4"+
    "\3\0\20\4\1\u0108\10\4\4\0\1\4\2\0\1\4"+
    "\12\0\2\4\7\0\10\4\3\0\21\4\1\u0109\7\4"+
    "\4\0\1\4\2\0\1\4\12\0\2\4\7\0\10\4"+
    "\3\0\11\4\1\u010a\17\4\4\0\1\4\2\0\1\4"+
    "\12\0\2\4\7\0\10\4\3\0\11\4\1\u010b\17\4"+
    "\4\0\1\4\2\0\1\4\12\0\2\4\7\0\10\4"+
    "\3\0\3\4\1\u010c\25\4\4\0\1\4\2\0\1\4"+
    "\12\0\2\4\7\0\10\4\3\0\15\4\1\u010d\13\4"+
    "\4\0\1\4\2\0\1\4\12\0\2\4\7\0\10\4"+
    "\3\0\23\4\1\u010e\5\4\4\0\1\4\2\0\1\4"+
    "\12\0\2\4\7\0\10\4\3\0\22\4\1\u010f\6\4"+
    "\4\0\1\4\2\0\1\4\12\0\2\4\7\0\10\4"+
    "\3\0\21\4\1\u0110\7\4\4\0\1\4\2\0\1\4"+
    "\12\0\2\4\7\0\10\4\3\0\27\4\1\u0111\1\4"+
    "\4\0\1\4\2\0\1\4\12\0\2\4\7\0\10\4"+
    "\3\0\5\4\1\u0112\23\4\4\0\1\4\2\0\1\4"+
    "\12\0\2\4\7\0\10\4\3\0\3\4\1\u0113\25\4"+
    "\4\0\1\4\2\0\1\4\12\0\2\4\7\0\10\4"+
    "\3\0\1\4\1\u0114\27\4\4\0\1\4\2\0\1\4"+
    "\12\0\2\4\7\0\10\4\3\0\5\4\1\u0115\23\4"+
    "\4\0\1\4\2\0\1\4\12\0\2\4\7\0\10\4"+
    "\3\0\5\4\1\u0116\23\4\4\0\1\4\2\0\1\4"+
    "\12\0\2\4\7\0\10\4\3\0\22\4\1\u0117\6\4"+
    "\4\0\1\4\2\0\1\4\12\0\2\4\7\0\10\4"+
    "\3\0\6\4\1\u0118\22\4\4\0\1\4\2\0\1\4"+
    "\12\0\2\4\7\0\10\4\3\0\16\4\1\u0119\12\4"+
    "\4\0\1\4\2\0\1\4\12\0\2\4\7\0\10\4"+
    "\3\0\5\4\1\u011a\23\4\4\0\1\4\2\0\1\4"+
    "\12\0\2\4\7\0\10\4\3\0\13\4\1\u011b\15\4"+
    "\4\0\1\4\2\0\1\4\12\0\2\4\7\0\10\4"+
    "\3\0\22\4\1\u011c\6\4\4\0\1\4\2\0\1\4"+
    "\12\0\2\4\7\0\10\4\3\0\5\4\1\u011d\23\4"+
    "\4\0\1\4\2\0\1\4\12\0\2\4\7\0\10\4"+
    "\3\0\15\4\1\u011e\13\4\4\0\1\4\2\0\1\4"+
    "\12\0\2\4\7\0\10\4\3\0\5\4\1\u011f\23\4"+
    "\4\0\1\4\2\0\1\4\12\0\2\4\7\0\10\4"+
    "\3\0\3\4\1\u0120\25\4\4\0\1\4\2\0\1\4"+
    "\12\0\2\4\7\0\10\4\3\0\5\4\1\u0121\23\4"+
    "\4\0\1\4\2\0\1\4\12\0\2\4\7\0\10\4"+
    "\3\0\17\4\1\u0122\11\4\4\0\1\4\2\0\1\4"+
    "\12\0\2\4\7\0\10\4\3\0\15\4\1\u0123\13\4"+
    "\4\0\1\4\2\0\1\4\12\0\2\4\7\0\10\4"+
    "\3\0\15\4\1\u0124\13\4\4\0\1\4\2\0\1\4"+
    "\12\0\2\4\7\0\10\4\3\0\5\4\1\u0125\23\4"+
    "\4\0\1\4\2\0\1\4\12\0\2\4\7\0\10\4"+
    "\3\0\22\4\1\u0126\6\4\4\0\1\4\2\0\1\4"+
    "\12\0\2\4\7\0\10\4\3\0\16\4\1\u0127\12\4"+
    "\4\0\1\4\2\0\1\4\12\0\2\4\7\0\10\4"+
    "\3\0\5\4\1\u0128\23\4\4\0\1\4\2\0\1\4"+
    "\12\0\2\4\7\0\10\4\3\0\4\4\1\u0129\24\4"+
    "\4\0\1\4\2\0\1\4\12\0\2\4\7\0\10\4"+
    "\3\0\11\4\1\u012a\17\4\4\0\1\4\2\0\1\4"+
    "\12\0\2\4\7\0\10\4\3\0\22\4\1\u012b\6\4"+
    "\4\0\1\4\2\0\1\4\12\0\2\4\7\0\10\4"+
    "\3\0\21\4\1\u012c\7\4\4\0\1\4\2\0\1\4"+
    "\12\0\2\4\7\0\10\4\3\0\6\4\1\u012d\22\4"+
    "\4\0\1\4\2\0\1\4\12\0\2\4\7\0\10\4"+
    "\3\0\30\4\1\u012e\4\0\1\4\2\0\1\4\12\0"+
    "\2\4\7\0\10\4\3\0\5\4\1\u012f\23\4\4\0"+
    "\1\4\2\0\1\4\12\0\2\4\7\0\10\4\3\0"+
    "\4\4\1\u0130\24\4\4\0";

  private static int [] zzUnpacktrans() {
    int [] result = new int[13923];
    int offset = 0;
    offset = zzUnpacktrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpacktrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /* error codes */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  private static final int ZZ_NO_MATCH = 1;
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /* error messages for the codes above */
  private static final String[] ZZ_ERROR_MSG = {
    "Unknown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state {@code aState}
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\1\0\1\11\4\1\2\11\2\1\1\11\6\1\1\11"+
    "\2\1\5\11\21\1\1\11\1\1\14\11\1\0\1\1"+
    "\1\11\1\1\1\11\1\1\2\11\1\1\1\11\1\1"+
    "\3\11\47\1\3\11\1\1\1\0\1\1\1\11\56\1"+
    "\1\0\215\1";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[304];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** the input device */
  private java.io.Reader zzReader;

  /** the current state of the DFA */
  private int zzState;

  /** the current lexical state */
  private int zzLexicalState = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private CharSequence zzBuffer = "";

  /** the textposition at the last accepting state */
  private int zzMarkedPos;

  /** the current text position in the buffer */
  private int zzCurrentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int zzStartRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int zzEndRead;

  /** zzAtEOF == true <=> the scanner is at the EOF */
  private boolean zzAtEOF;

  /** Number of newlines encountered up to the start of the matched text. */
  @SuppressWarnings("unused")
  private int yyline;

  /** Number of characters from the last newline up to the start of the matched text. */
  @SuppressWarnings("unused")
  protected int yycolumn;

  /** Number of characters up to the start of the matched text. */
  @SuppressWarnings("unused")
  private long yychar;

  /** Whether the scanner is currently at the beginning of a line. */
  @SuppressWarnings("unused")
  private boolean zzAtBOL = true;

  /** Whether the user-EOF-code has already been executed. */
  @SuppressWarnings("unused")
  private boolean zzEOFDone;

  /* user code: */
  private boolean myAssertKeyword;
  private boolean myEnumKeyword;

  public _JavaLexer(LanguageLevel level) {
    this((java.io.Reader)null);
    myAssertKeyword = level.isAtLeast(LanguageLevel.JDK_1_4);
    myEnumKeyword = level.isAtLeast(LanguageLevel.JDK_1_5);
  }

  public void goTo(int offset) {
    zzCurrentPos = zzMarkedPos = zzStartRead = offset;
    zzAtEOF = false;
  }


  /**
   * Creates a new scanner
   *
   * @param   in  the java.io.Reader to read input from.
   */
  _JavaLexer(java.io.Reader in) {
    this.zzReader = in;
  }


  /** Returns the maximum size of the scanner buffer, which limits the size of tokens. */
  private int zzMaxBufferLen() {
    return Integer.MAX_VALUE;
  }

  /**  Whether the scanner buffer can grow to accommodate a larger token. */
  private boolean zzCanGrow() {
    return true;
  }

  /**
   * Translates raw input code points to DFA table row
   */
  private static int zzCMap(int input) {
    int offset = input & 255;
    return offset == input ? ZZ_CMAP_BLOCKS[offset] : ZZ_CMAP_BLOCKS[ZZ_CMAP_TOP[input >> 8] | offset];
  }

  public final int getTokenStart() {
    return zzStartRead;
  }

  public final int getTokenEnd() {
    return getTokenStart() + yylength();
  }

  public void reset(CharSequence buffer, int start, int end, int initialState) {
    zzBuffer = buffer;
    zzCurrentPos = zzMarkedPos = zzStartRead = start;
    zzAtEOF  = false;
    zzAtBOL = true;
    zzEndRead = end;
    yybegin(initialState);
  }

  /**
   * Refills the input buffer.
   *
   * @return      {@code false}, iff there was new input.
   *
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  private boolean zzRefill() throws java.io.IOException {
    return true;
  }


  /**
   * Returns the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  public final CharSequence yytext() {
    return zzBuffer.subSequence(zzStartRead, zzMarkedPos);
  }


  /**
   * Returns the character at position {@code pos} from the
   * matched text.
   *
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch.
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  public final char yycharat(int pos) {
    return zzBuffer.charAt(zzStartRead+pos);
  }


  /**
   * Returns the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occurred while scanning.
   *
   * In a wellformed scanner (no or only correct usage of
   * yypushback(int) and a match-all fallback rule) this method
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    }
    catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  }


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  public IElementType advance() throws java.io.IOException
  {
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    CharSequence zzBufferL = zzBuffer;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

    while (true) {
      zzMarkedPosL = zzMarkedPos;

      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;

      zzState = ZZ_LEXSTATE[zzLexicalState];

      // set up zzAction for empty match case:
      int zzAttributes = zzAttrL[zzState];
      if ( (zzAttributes & 1) == 1 ) {
        zzAction = zzState;
      }


      zzForAction: {
        while (true) {

          if (zzCurrentPosL < zzEndReadL) {
            zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL);
            zzCurrentPosL += Character.charCount(zzInput);
          }
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL);
              zzCurrentPosL += Character.charCount(zzInput);
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + zzCMap(zzInput) ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
        zzAtEOF = true;
        return null;
      }
      else {
        switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
          case 1:
            { return JavaTokenType.BAD_CHARACTER;
            }
          // fall through
          case 105: break;
          case 2:
            { return JavaTokenType.EXCL;
            }
          // fall through
          case 106: break;
          case 3:
            { return JavaTokenType.IDENTIFIER;
            }
          // fall through
          case 107: break;
          case 4:
            { return JavaTokenType.PERC;
            }
          // fall through
          case 108: break;
          case 5:
            { return JavaTokenType.AND;
            }
          // fall through
          case 109: break;
          case 6:
            { return JavaTokenType.LPARENTH;
            }
          // fall through
          case 110: break;
          case 7:
            { return JavaTokenType.RPARENTH;
            }
          // fall through
          case 111: break;
          case 8:
            { return JavaTokenType.ASTERISK;
            }
          // fall through
          case 112: break;
          case 9:
            { return JavaTokenType.PLUS;
            }
          // fall through
          case 113: break;
          case 10:
            { return JavaTokenType.COMMA;
            }
          // fall through
          case 114: break;
          case 11:
            { return JavaTokenType.MINUS;
            }
          // fall through
          case 115: break;
          case 12:
            { return JavaTokenType.DOT;
            }
          // fall through
          case 116: break;
          case 13:
            { return JavaTokenType.DIV;
            }
          // fall through
          case 117: break;
          case 14:
            { return JavaTokenType.INTEGER_LITERAL;
            }
          // fall through
          case 118: break;
          case 15:
            { return JavaTokenType.COLON;
            }
          // fall through
          case 119: break;
          case 16:
            { return JavaTokenType.SEMICOLON;
            }
          // fall through
          case 120: break;
          case 17:
            { return JavaTokenType.LT;
            }
          // fall through
          case 121: break;
          case 18:
            { return JavaTokenType.EQ;
            }
          // fall through
          case 122: break;
          case 19:
            { return JavaTokenType.GT;
            }
          // fall through
          case 123: break;
          case 20:
            { return JavaTokenType.QUEST;
            }
          // fall through
          case 124: break;
          case 21:
            { return JavaTokenType.AT;
            }
          // fall through
          case 125: break;
          case 22:
            { return JavaTokenType.LBRACKET;
            }
          // fall through
          case 126: break;
          case 23:
            { return JavaTokenType.RBRACKET;
            }
          // fall through
          case 127: break;
          case 24:
            { return JavaTokenType.XOR;
            }
          // fall through
          case 128: break;
          case 25:
            { return JavaTokenType.LBRACE;
            }
          // fall through
          case 129: break;
          case 26:
            { return JavaTokenType.OR;
            }
          // fall through
          case 130: break;
          case 27:
            { return JavaTokenType.RBRACE;
            }
          // fall through
          case 131: break;
          case 28:
            { return JavaTokenType.TILDE;
            }
          // fall through
          case 132: break;
          case 29:
            { return JavaTokenType.NE;
            }
          // fall through
          case 133: break;
          case 30:
            { return JavaTokenType.PERCEQ;
            }
          // fall through
          case 134: break;
          case 31:
            { return JavaTokenType.ANDAND;
            }
          // fall through
          case 135: break;
          case 32:
            { return JavaTokenType.ANDEQ;
            }
          // fall through
          case 136: break;
          case 33:
            { return JavaTokenType.ASTERISKEQ;
            }
          // fall through
          case 137: break;
          case 34:
            { return JavaTokenType.PLUSPLUS;
            }
          // fall through
          case 138: break;
          case 35:
            { return JavaTokenType.PLUSEQ;
            }
          // fall through
          case 139: break;
          case 36:
            { return JavaTokenType.MINUSMINUS;
            }
          // fall through
          case 140: break;
          case 37:
            { return JavaTokenType.MINUSEQ;
            }
          // fall through
          case 141: break;
          case 38:
            { return JavaTokenType.ARROW;
            }
          // fall through
          case 142: break;
          case 39:
            { return JavaTokenType.DOUBLE_LITERAL;
            }
          // fall through
          case 143: break;
          case 40:
            { return JavaTokenType.DIVEQ;
            }
          // fall through
          case 144: break;
          case 41:
            { return JavaTokenType.FLOAT_LITERAL;
            }
          // fall through
          case 145: break;
          case 42:
            { return JavaTokenType.LONG_LITERAL;
            }
          // fall through
          case 146: break;
          case 43:
            { return JavaTokenType.DOUBLE_COLON;
            }
          // fall through
          case 147: break;
          case 44:
            { return JavaTokenType.LTLT;
            }
          // fall through
          case 148: break;
          case 45:
            { return JavaTokenType.LE;
            }
          // fall through
          case 149: break;
          case 46:
            { return JavaTokenType.EQEQ;
            }
          // fall through
          case 150: break;
          case 47:
            { return JavaTokenType.XOREQ;
            }
          // fall through
          case 151: break;
          case 48:
            { return JavaTokenType.DO_KEYWORD;
            }
          // fall through
          case 152: break;
          case 49:
            { return JavaTokenType.IF_KEYWORD;
            }
          // fall through
          case 153: break;
          case 50:
            { return JavaTokenType.OREQ;
            }
          // fall through
          case 154: break;
          case 51:
            { return JavaTokenType.OROR;
            }
          // fall through
          case 155: break;
          case 52:
            { return JavaTokenType.ELLIPSIS;
            }
          // fall through
          case 156: break;
          case 53:
            { return JavaTokenType.LTLTEQ;
            }
          // fall through
          case 157: break;
          case 54:
            { return JavaTokenType.FOR_KEYWORD;
            }
          // fall through
          case 158: break;
          case 55:
            { return JavaTokenType.INT_KEYWORD;
            }
          // fall through
          case 159: break;
          case 56:
            { return JavaTokenType.NEW_KEYWORD;
            }
          // fall through
          case 160: break;
          case 57:
            { return JavaTokenType.TRY_KEYWORD;
            }
          // fall through
          case 161: break;
          case 58:
            { return JavaTokenType.BYTE_KEYWORD;
            }
          // fall through
          case 162: break;
          case 59:
            { return JavaTokenType.CASE_KEYWORD;
            }
          // fall through
          case 163: break;
          case 60:
            { return JavaTokenType.CHAR_KEYWORD;
            }
          // fall through
          case 164: break;
          case 61:
            { return JavaTokenType.ELSE_KEYWORD;
            }
          // fall through
          case 165: break;
          case 62:
            { return myEnumKeyword ? JavaTokenType.ENUM_KEYWORD : JavaTokenType.IDENTIFIER;
            }
          // fall through
          case 166: break;
          case 63:
            { return JavaTokenType.GOTO_KEYWORD;
            }
          // fall through
          case 167: break;
          case 64:
            { return JavaTokenType.LONG_KEYWORD;
            }
          // fall through
          case 168: break;
          case 65:
            { return JavaTokenType.NULL_KEYWORD;
            }
          // fall through
          case 169: break;
          case 66:
            { return JavaTokenType.THIS_KEYWORD;
            }
          // fall through
          case 170: break;
          case 67:
            { return JavaTokenType.TRUE_KEYWORD;
            }
          // fall through
          case 171: break;
          case 68:
            { return JavaTokenType.VOID_KEYWORD;
            }
          // fall through
          case 172: break;
          case 69:
            { return JavaTokenType.BREAK_KEYWORD;
            }
          // fall through
          case 173: break;
          case 70:
            { return JavaTokenType.CATCH_KEYWORD;
            }
          // fall through
          case 174: break;
          case 71:
            { return JavaTokenType.CLASS_KEYWORD;
            }
          // fall through
          case 175: break;
          case 72:
            { return JavaTokenType.CONST_KEYWORD;
            }
          // fall through
          case 176: break;
          case 73:
            { return JavaTokenType.FALSE_KEYWORD;
            }
          // fall through
          case 177: break;
          case 74:
            { return JavaTokenType.FINAL_KEYWORD;
            }
          // fall through
          case 178: break;
          case 75:
            { return JavaTokenType.FLOAT_KEYWORD;
            }
          // fall through
          case 179: break;
          case 76:
            { return JavaTokenType.SHORT_KEYWORD;
            }
          // fall through
          case 180: break;
          case 77:
            { return JavaTokenType.SUPER_KEYWORD;
            }
          // fall through
          case 181: break;
          case 78:
            { return JavaTokenType.THROW_KEYWORD;
            }
          // fall through
          case 182: break;
          case 79:
            { return JavaTokenType.WHILE_KEYWORD;
            }
          // fall through
          case 183: break;
          case 80:
            { return myAssertKeyword ? JavaTokenType.ASSERT_KEYWORD : JavaTokenType.IDENTIFIER;
            }
          // fall through
          case 184: break;
          case 81:
            { return JavaTokenType.DOUBLE_KEYWORD;
            }
          // fall through
          case 185: break;
          case 82:
            { return JavaTokenType.IMPORT_KEYWORD;
            }
          // fall through
          case 186: break;
          case 83:
            { return JavaTokenType.NATIVE_KEYWORD;
            }
          // fall through
          case 187: break;
          case 84:
            { return JavaTokenType.PUBLIC_KEYWORD;
            }
          // fall through
          case 188: break;
          case 85:
            { return JavaTokenType.RETURN_KEYWORD;
            }
          // fall through
          case 189: break;
          case 86:
            { return JavaTokenType.STATIC_KEYWORD;
            }
          // fall through
          case 190: break;
          case 87:
            { return JavaTokenType.SWITCH_KEYWORD;
            }
          // fall through
          case 191: break;
          case 88:
            { return JavaTokenType.THROWS_KEYWORD;
            }
          // fall through
          case 192: break;
          case 89:
            { return JavaTokenType.BOOLEAN_KEYWORD;
            }
          // fall through
          case 193: break;
          case 90:
            { return JavaTokenType.DEFAULT_KEYWORD;
            }
          // fall through
          case 194: break;
          case 91:
            { return JavaTokenType.EXTENDS_KEYWORD;
            }
          // fall through
          case 195: break;
          case 92:
            { return JavaTokenType.FINALLY_KEYWORD;
            }
          // fall through
          case 196: break;
          case 93:
            { return JavaTokenType.PACKAGE_KEYWORD;
            }
          // fall through
          case 197: break;
          case 94:
            { return JavaTokenType.PRIVATE_KEYWORD;
            }
          // fall through
          case 198: break;
          case 95:
            { return JavaTokenType.ABSTRACT_KEYWORD;
            }
          // fall through
          case 199: break;
          case 96:
            { return JavaTokenType.CONTINUE_KEYWORD;
            }
          // fall through
          case 200: break;
          case 97:
            { return JavaTokenType.STRICTFP_KEYWORD;
            }
          // fall through
          case 201: break;
          case 98:
            { return JavaTokenType.VOLATILE_KEYWORD;
            }
          // fall through
          case 202: break;
          case 99:
            { return JavaTokenType.INTERFACE_KEYWORD;
            }
          // fall through
          case 203: break;
          case 100:
            { return JavaTokenType.PROTECTED_KEYWORD;
            }
          // fall through
          case 204: break;
          case 101:
            { return JavaTokenType.TRANSIENT_KEYWORD;
            }
          // fall through
          case 205: break;
          case 102:
            { return JavaTokenType.IMPLEMENTS_KEYWORD;
            }
          // fall through
          case 206: break;
          case 103:
            { return JavaTokenType.INSTANCEOF_KEYWORD;
            }
          // fall through
          case 207: break;
          case 104:
            { return JavaTokenType.SYNCHRONIZED_KEYWORD;
            }
          // fall through
          case 208: break;
          default:
            zzScanError(ZZ_NO_MATCH);
          }
      }
    }
  }


}
