// Copyright 2000-2022 JetBrains s.r.o. and contributors. Use of this source code is governed by the Apache 2.0 license.
package ksp.com.intellij.openapi.util.io;

import ksp.com.intellij.openapi.util.NlsSafe;
import ksp.com.intellij.openapi.util.text.StringUtil;
import ksp.com.intellij.openapi.util.text.Strings;
import ksp.com.intellij.util.EnvironmentUtil;
import ksp.com.intellij.util.concurrency.SynchronizedClearableLazy;
import ksp.org.jetbrains.annotations.NotNull;

import java.io.File;
import java.util.function.Supplier;

public final class PathExecLazyValue {
  private PathExecLazyValue() { }

  public static @NotNull Supplier<Boolean> create(@NlsSafe @NotNull String name) {
    if (Strings.containsAnyChar(name, "/\\")) {
      throw new IllegalArgumentException(name);
    }

    return new SynchronizedClearableLazy<>(() -> {
      String path = EnvironmentUtil.getValue("PATH");
      if (path != null) {
        for (String dir : StringUtil.tokenize(path, File.pathSeparator)) {
          if (new File(dir, name).canExecute()) {
            return true;
          }
        }
      }

      return false;
    });
  }
}
