/*
 * Copyright 2010-2024 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package ksp.org.jetbrains.kotlin.analysis.api.impl.base.components

import ksp.org.jetbrains.kotlin.analysis.api.KaImplementationDetail
import ksp.org.jetbrains.kotlin.analysis.api.KaSession
import ksp.org.jetbrains.kotlin.analysis.api.components.KaSignatureSubstitutor
import ksp.org.jetbrains.kotlin.analysis.api.lifetime.withValidityAssertion
import ksp.org.jetbrains.kotlin.analysis.api.signatures.KaCallableSignature
import ksp.org.jetbrains.kotlin.analysis.api.signatures.KaFunctionSignature
import ksp.org.jetbrains.kotlin.analysis.api.signatures.KaVariableSignature
import ksp.org.jetbrains.kotlin.analysis.api.symbols.KaCallableSymbol
import ksp.org.jetbrains.kotlin.analysis.api.symbols.KaFunctionSymbol
import ksp.org.jetbrains.kotlin.analysis.api.symbols.KaVariableSymbol
import ksp.org.jetbrains.kotlin.analysis.api.types.KaSubstitutor

@KaImplementationDetail
abstract class KaBaseSignatureSubstitutor<T : KaSession> : KaBaseSessionComponent<T>(), KaSignatureSubstitutor {
    override fun <S : KaFunctionSymbol> S.substitute(substitutor: KaSubstitutor): KaFunctionSignature<S> = withValidityAssertion {
        if (substitutor is KaSubstitutor.Empty) return asSignature()
        return asSignature().substitute(substitutor)
    }

    override fun <S : KaVariableSymbol> S.substitute(substitutor: KaSubstitutor): KaVariableSignature<S> = withValidityAssertion {
        if (substitutor is KaSubstitutor.Empty) return asSignature()
        return asSignature().substitute(substitutor)
    }

    override fun <S : KaCallableSymbol> S.substitute(substitutor: KaSubstitutor): KaCallableSignature<S> = withValidityAssertion {
        when (this) {
            is KaFunctionSymbol -> substitute(substitutor)
            is KaVariableSymbol -> substitute(substitutor)
        }
    }

    override fun <S : KaCallableSymbol> S.asSignature(): KaCallableSignature<S> = withValidityAssertion {
        return when (this) {
            is KaFunctionSymbol -> asSignature()
            is KaVariableSymbol -> asSignature()
        }
    }
}
