/*
 * Copyright 2010-2025 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package ksp.org.jetbrains.kotlin.analysis.api.impl.base.projectStructure

import ksp.com.intellij.psi.search.GlobalSearchScope
import ksp.org.jetbrains.kotlin.analysis.api.KaImplementationDetail
import ksp.org.jetbrains.kotlin.analysis.api.platform.projectStructure.KotlinContentScopeRefiner
import ksp.org.jetbrains.kotlin.analysis.api.projectStructure.KaModule
import ksp.org.jetbrains.kotlin.analysis.api.resolve.extensions.KaResolveExtensionProvider

@KaImplementationDetail
class KaResolveExtensionToContentScopeRefinerBridge : KotlinContentScopeRefiner {
    override fun getEnlargementScopes(module: KaModule): List<GlobalSearchScope> =
        buildList {
            if (KaResolveExtensionProvider.provideExtensionsFor(module).isNotEmpty()) {
                add(KaBaseResolveExtensionGeneratedFilesScope(listOf(module)))
            }
        }

    override fun getRestrictionScopes(module: KaModule): List<GlobalSearchScope> =
        KaResolveExtensionProvider.provideExtensionsFor(module).map { resolveExtension ->
            GlobalSearchScope.notScope(resolveExtension.getShadowedScope())
        }
}
