/*
 * Copyright 2010-2021 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration

import ksp.org.jetbrains.kotlin.KtNodeTypes
import ksp.org.jetbrains.kotlin.KtRealSourceElementKind
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.checkTypeMismatch
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext
import ksp.org.jetbrains.kotlin.fir.declarations.FirProperty
import ksp.org.jetbrains.kotlin.fir.expressions.FirComponentCall
import ksp.org.jetbrains.kotlin.fir.expressions.FirErrorExpression
import ksp.org.jetbrains.kotlin.fir.types.coneType

object FirInitializerTypeMismatchChecker : FirPropertyChecker(MppCheckerKind.Common) {
    context(context: CheckerContext, reporter: DiagnosticReporter)
    override fun check(declaration: FirProperty) {
        val initializer = declaration.initializer?.takeIf { it !is FirErrorExpression } ?: return
        val source = declaration.source ?: return
        if (source.elementType == KtNodeTypes.DESTRUCTURING_DECLARATION) return
        if (initializer is FirComponentCall) return
        if (declaration.returnTypeRef.source?.kind != KtRealSourceElementKind) return
        val propertyType = declaration.returnTypeRef.coneType

        checkTypeMismatch(propertyType, null, initializer, source, true)
    }
}
